/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.entity.hostile.golem;

import com.BrassAmber.ba_bt.block.block.GolemChestBlock;
import com.BrassAmber.ba_bt.block.block.TowerChestBlock;
import com.BrassAmber.ba_bt.entity.ai.target.TargetTaskGolem;
import com.BrassAmber.ba_bt.init.BTEntityTypes;
import com.BrassAmber.ba_bt.init.BTItems;
import com.BrassAmber.ba_bt.sound.BTSoundEvents;
import com.BrassAmber.ba_bt.util.BTUtil;
import com.BrassAmber.ba_bt.util.GolemType;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public abstract class BTAbstractGolem
extends Monster {
    protected static final EntityDataAccessor<BlockPos> SPAWN_POS = SynchedEntityData.m_135353_(BTAbstractGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    protected static final EntityDataAccessor<Float> SPAWN_DIRECTION = SynchedEntityData.m_135353_(BTAbstractGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Byte> GOLEM_STATE = SynchedEntityData.m_135353_(BTAbstractGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(BTAbstractGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final MobType BATTLE_GOLEM = MobType.f_21640_;
    public static final byte DORMANT = 0;
    public static final byte AWAKE = 1;
    public static final byte SPECIAL = 2;
    public static final float SCALE = 0.9f;
    private final ServerBossEvent bossBar;
    protected int explosionPower = 1;
    protected Component GolemName;
    public GolemType golemType;
    protected final String spawnPosName = "SpawnPos";
    protected final String spawnDirectionName = "SpawnDirection";
    protected final String golemStateName = "GolemState";
    protected final String explosionPowerName = "ExplosionPower";
    public Music BOSS_MUSIC;
    protected MusicManager music;

    protected BTAbstractGolem(EntityType<? extends Monster> type, Level levelIn, BossEvent.BossBarColor bossBarColor) {
        super(type, levelIn);
        this.bossBar = new ServerBossEvent((Component)new TextComponent(""), bossBarColor, BossEvent.BossBarOverlay.PROGRESS);
        this.bossBar.m_7006_(false);
        this.f_19793_ = 2.0f;
        this.music = null;
    }

    public int getAllowedTowerRange() {
        return 32;
    }

    public int getWakeUpRange() {
        return 6;
    }

    public int getTargetingRange() {
        return this.getAllowedTowerRange() / 4 * 3;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPAWN_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(SPAWN_DIRECTION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(GOLEM_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_(this.spawnPosName, (Tag)this.m_20063_(new double[]{this.getSpawnPos().m_123341_(), this.getSpawnPos().m_123342_(), this.getSpawnPos().m_123343_()}));
        compound.m_128350_(this.spawnDirectionName, this.getSpawnDirection().floatValue());
        compound.m_128344_(this.golemStateName, this.getGolemState());
        compound.m_128405_(this.explosionPowerName, this.explosionPower);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ListTag spawnPos = compound.m_128437_(this.spawnPosName, 6);
        double x = spawnPos.m_128772_(0);
        double y = spawnPos.m_128772_(1);
        double z = spawnPos.m_128772_(2);
        this.setSpawnPos(new BlockPos(x, y, z));
        this.setSpawnDirection(compound.m_128457_(this.spawnDirectionName));
        this.setGolemState(compound.m_128445_(this.golemStateName));
        if (compound.m_128425_(this.explosionPowerName, 99)) {
            this.explosionPower = compound.m_128451_("ExplosionPower");
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.isEnragedBasedOnHP() && !this.isEnraged() && this.isAwake()) {
            this.playSoundEvent(BTSoundEvents.ENTITY_GOLEM_SPECIAL, 0.3f);
            this.setGolemState((byte)2);
        }
        if (this.f_19853_.m_5776_()) {
            ClientLevel client = (ClientLevel)this.f_19853_;
            if (this.music == null) {
                this.music = client.f_104565_.m_91397_();
            }
            if (client.m_6907_().size() == 0) {
                return;
            }
            boolean hasClientPlayer = client.m_45914_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 30.0);
            if (this.isDormant()) {
                if (this.music.m_120187_(this.BOSS_MUSIC)) {
                    this.music.m_120186_();
                }
            } else {
                if (!this.music.m_120187_(this.BOSS_MUSIC) && this.isAwake()) {
                    this.music.m_120186_();
                    this.music.f_120180_ = this.BOSS_MUSIC.m_11636_();
                    this.music.m_120184_(this.BOSS_MUSIC);
                }
                if (!hasClientPlayer) {
                    this.music.f_120180_ = 500;
                    this.music.m_120186_();
                }
            }
            return;
        }
        Player player = this.f_19853_.m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)this.getTargetingRange(), true);
        boolean survivalAdventure = player != null ? EntitySelector.f_20406_.test(player) && EntitySelector.f_20403_.test(player) : false;
        if (this.isDormant()) {
            player = this.f_19853_.m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)this.getWakeUpRange(), true);
            if (player != null && survivalAdventure && this.m_142582_((Entity)player)) {
                this.wakeUpGolem();
                this.m_6710_((LivingEntity)player);
            }
        } else {
            if (player != null && survivalAdventure && !this.m_142582_((Entity)player) && this.f_19797_ > 0 && this.f_19797_ % 20 == 0) {
                this.destroyBlocksNearby();
            } else if (this.f_19797_ > 0 && this.f_19797_ % 200 == 0) {
                this.destroyBlocksNearby();
            }
            if (this.m_5448_() == null && player != null && survivalAdventure && this.m_142582_((Entity)player)) {
                this.m_6710_((LivingEntity)player);
            }
        }
        this.resetGolemTick();
        this.healGolemTick();
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        Player player;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            super.m_6710_(null);
        } else {
            super.m_6710_(livingEntity);
        }
    }

    protected void resetGolemTick() {
        int maxDistanceFromSpawn = this.getAllowedTowerRange();
        maxDistanceFromSpawn *= maxDistanceFromSpawn;
        BlockPos spawnPos = this.getSpawnPos();
        if (BTUtil.sqrDistanceTo2D((Entity)this, spawnPos.m_123341_(), spawnPos.m_123343_()) > (double)maxDistanceFromSpawn) {
            this.resetGolem();
            return;
        }
        boolean hasPlayer = this.f_19853_.m_45914_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)this.getTargetingRange());
        if (!hasPlayer) {
            this.resetGolem();
        }
    }

    protected void healGolemTick() {
        boolean isEachSecond;
        boolean bl = isEachSecond = this.f_19797_ % 20 == 0;
        if (this.m_21223_() < this.m_21233_() && this.isDormant() && isEachSecond) {
            this.m_5634_(this.m_21233_() / 200.0f);
        }
    }

    private void destroyBlocksNearby() {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) && this.m_5448_() != null && this.isAwake()) {
            Vec3 offset = this.m_20154_().m_82541_().m_82490_(0.5);
            int ox = Mth.m_14107_((double)(this.m_20185_() + offset.f_82479_));
            int oy = Mth.m_14107_((double)(this.m_20186_() + 0.25));
            int oz = Mth.m_14107_((double)(this.m_20189_() + offset.f_82481_));
            int width = Mth.m_14167_((float)(this.m_20205_() / 2.0f));
            int height = Mth.m_14167_((float)this.m_20206_());
            boolean playEffectFlag = false;
            for (int ix = ox - width; ix <= ox + width; ++ix) {
                for (int iy = oy; iy <= oy + height; ++iy) {
                    for (int iz = oz - width; iz <= oz + width; ++iz) {
                        boolean isChest;
                        BlockPos pos = new BlockPos(ix, iy, iz);
                        BlockState state = this.f_19853_.m_8055_(pos);
                        boolean bl = isChest = state.m_60734_() instanceof GolemChestBlock || state.m_60734_() instanceof TowerChestBlock;
                        if (isChest) continue;
                        if (state.canEntityDestroy((BlockGetter)this.f_19853_, pos, (Entity)this) && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)pos, (BlockState)state)) {
                            playEffectFlag |= this.f_19853_.m_46953_(pos, true, (Entity)this);
                        }
                        if (!(state.m_60734_() instanceof FireBlock)) continue;
                        this.f_19853_.m_46953_(pos, false, (Entity)this);
                    }
                }
            }
            if (playEffectFlag) {
                this.f_19853_.m_151555_(GameEvent.f_157794_, this.m_142538_());
            }
        }
    }

    public void setCharging(boolean setCharging) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)setCharging);
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source.m_19384_()) {
            return super.m_6469_(source, 0.0f);
        }
        if (source.m_19372_()) {
            return super.m_6469_(source, damage / 4.0f);
        }
        if (!this.isDormant()) {
            float multiplier;
            float f = multiplier = this.isEnraged() ? 0.5f : 1.0f;
            if (source.m_19360_()) {
                return super.m_6469_(source, damage * multiplier / 2.0f);
            }
            return super.m_6469_(source, damage / multiplier);
        }
        if (source.m_19390_() && this.isDormant()) {
            this.setGolemState((byte)1);
        }
        return source.equals(DamageSource.f_19317_) && super.m_6469_(source, damage);
    }

    public void m_6667_(@NotNull DamageSource source) {
        if (this.f_19853_.m_5776_()) {
            ((ClientLevel)this.f_19853_).f_104565_.m_91397_().m_120186_();
        }
        super.m_6667_(source);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f){

            public boolean m_8036_() {
                return !BTAbstractGolem.this.isDormant() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !BTAbstractGolem.this.isDormant() && super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, new TargetTaskGolem<BTAbstractGolem>(this));
        this.addBehaviorGoals();
    }

    protected void addBehaviorGoals() {
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true){

            public boolean m_8036_() {
                return !BTAbstractGolem.this.isDormant() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !BTAbstractGolem.this.isDormant() && super.m_8045_();
            }
        });
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setSpawnPos(this.m_142538_());
        this.setSpawnDirection(this.m_146908_());
        return spawnDataIn;
    }

    @NotNull
    public MobType m_6336_() {
        return BATTLE_GOLEM;
    }

    protected float m_6108_() {
        return 0.2f;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == this.m_6336_()) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public Component m_5446_() {
        return PlayerTeam.m_83348_((Team)this.m_5647_(), (Component)this.GolemName).m_130938_(p_185975_ -> p_185975_.m_131144_(this.m_20190_()).m_131138_(this.m_20149_()));
    }

    public void setGolemName(Component golemName) {
        this.GolemName = golemName;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_142535_(float damage, float multiplier, DamageSource source) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected boolean m_6129_() {
        return false;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.88f;
    }

    public ItemStack getPickedResult(HitResult target) {
        EntityType entityType = this.m_6095_();
        if (entityType.equals(BTEntityTypes.LAND_GOLEM.get())) {
            return new ItemStack((ItemLike)BTItems.LAND_MONOLITH.get());
        }
        if (entityType.equals(BTEntityTypes.OCEAN_GOLEM.get())) {
            return new ItemStack((ItemLike)BTItems.OCEAN_MONOLITH.get());
        }
        if (entityType.equals(BTEntityTypes.CORE_GOLEM.get())) {
            return new ItemStack((ItemLike)BTItems.CORE_MONOLITH.get());
        }
        if (entityType.equals(BTEntityTypes.NETHER_GOLEM.get())) {
            return new ItemStack((ItemLike)BTItems.NETHER_MONOLITH.get());
        }
        if (entityType.equals(BTEntityTypes.END_GOLEM.get())) {
            return new ItemStack((ItemLike)BTItems.END_MONOLITH.get());
        }
        if (entityType.equals(BTEntityTypes.SKY_GOLEM.get())) {
            return new ItemStack((ItemLike)BTItems.SKY_MONOLITH.get());
        }
        return ItemStack.f_41583_;
    }

    public byte getGolemState() {
        return (byte)Mth.m_14045_((int)((Byte)this.f_19804_.m_135370_(GOLEM_STATE)).byteValue(), (int)0, (int)2);
    }

    public void setGolemState(byte golemStateID) {
        this.f_19804_.m_135381_(GOLEM_STATE, (Object)golemStateID);
        if (golemStateID != 0 && !this.bossBar.m_8323_()) {
            this.bossBar.m_8321_(true);
        } else if (golemStateID == 0 && this.bossBar.m_8323_()) {
            this.bossBar.m_8321_(false);
        }
    }

    protected void wakeUpGolem() {
        this.setGolemState((byte)1);
    }

    public boolean isDormant() {
        return this.getGolemState() == 0;
    }

    public boolean isAwake() {
        return this.getGolemState() == 1;
    }

    public boolean isEnraged() {
        return this.getGolemState() == 2;
    }

    private void resetGolem() {
        if (this.isDormant()) {
            return;
        }
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        BlockPos spawnPos = this.getSpawnPos();
        if (this.m_20275_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_()) > 4.0) {
            this.m_6034_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
        }
        this.faceSpawnDirection();
        this.setGolemState((byte)0);
        this.m_6710_(null);
        this.m_21573_().m_26573_();
        LightningBolt lightning = new LightningBolt(EntityType.f_20465_, this.f_19853_);
        lightning.m_6034_(x, y, z);
        lightning.setDamage(0.0f);
        this.f_19853_.m_7967_((Entity)lightning);
    }

    private void faceSpawnDirection() {
        this.faceDirection(this.getSpawnDirection().floatValue());
    }

    public void faceDirection(float direction) {
        this.m_146922_(direction);
        this.m_5616_(direction);
        this.m_5618_(direction);
    }

    public void setSpawnPos(BlockPos spawnPos) {
        this.f_19804_.m_135381_(SPAWN_POS, (Object)spawnPos);
    }

    protected BlockPos getSpawnPos() {
        return (BlockPos)this.f_19804_.m_135370_(SPAWN_POS);
    }

    public Float getSpawnDirection() {
        return (Float)this.f_19804_.m_135370_(SPAWN_DIRECTION);
    }

    public void setSpawnDirection(float yRot) {
        this.f_19804_.m_135381_(SPAWN_DIRECTION, (Object)Float.valueOf(yRot));
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossBar.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossBar.m_6539_(player);
    }

    public void setBossBarName() {
        this.bossBar.m_6456_(this.m_5446_());
    }

    protected float m_6121_() {
        return 0.8f;
    }

    public float m_6100_() {
        return super.m_6100_();
    }

    public int m_8100_() {
        return 400;
    }

    protected SoundEvent m_7515_() {
        return this.isAwake() ? BTSoundEvents.ENTITY_GOLEM_AMBIENT : SoundEvents.f_11689_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        this.playSoundEvent(BTSoundEvents.ENTITY_GOLEM_HURT);
        return SoundEvents.f_12160_;
    }

    protected SoundEvent m_5592_() {
        return BTSoundEvents.ENTITY_GOLEM_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.playSoundEvent(SoundEvents.f_12010_);
    }

    public void playSoundEvent(SoundEvent soundEvent, float volume) {
        this.m_5496_(soundEvent, volume, this.m_6100_());
    }

    public void playSoundEvent(SoundEvent soundEvent) {
        this.playSoundEvent(soundEvent, this.m_6121_());
    }

    public void playSoundEventWithVariation(SoundEvent soundEvent) {
        this.m_5496_(soundEvent, this.m_6121_(), this.m_6100_() + this.getSmallPitchVariation());
    }

    private float getSmallPitchVariation() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f;
    }

    public boolean isEnragedBasedOnHP() {
        return this.m_21223_() / this.m_21233_() < 0.33f;
    }
}

