/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.entity.block;

import com.BrassAmber.ba_bt.BattleTowersConfig;
import com.BrassAmber.ba_bt.BrassAmberBattleTowers;
import com.BrassAmber.ba_bt.entity.block.BTAbstractObelisk;
import com.BrassAmber.ba_bt.init.BTBlocks;
import com.BrassAmber.ba_bt.init.BTExtras;
import com.BrassAmber.ba_bt.sound.BTSoundEvents;
import com.BrassAmber.ba_bt.util.BTStatics;
import com.BrassAmber.ba_bt.util.BTUtil;
import com.BrassAmber.ba_bt.util.GolemType;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BTOceanObelisk
extends BTAbstractObelisk {
    private final List<Block> avoidBlocks = BTStatics.towerBlocks.get(GolemType.getNumForType(GolemType.OCEAN));
    private final List<BlockState> corals = List.of(Blocks.f_50595_.m_49966_(), Blocks.f_50596_.m_49966_(), Blocks.f_50597_.m_49966_(), Blocks.f_50598_.m_49966_(), Blocks.f_50594_.m_49966_());
    private int noise;
    private int westWall;
    private int northWall;
    private int eastWall;
    private int southWall;
    private int top;
    private int bottom;
    private int currentCarveLayer;
    private double wallDistance;
    private int nextStep;
    private int distanceChange;
    private boolean oceanCarved = false;
    private final String oceanCarvedName = "OceanCarved";

    public BTOceanObelisk(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public BTOceanObelisk(Level level) {
        super(GolemType.OCEAN, level);
    }

    @Override
    public void initialize() {
        this.musicDistance = 58;
        this.towerRange = 62;
        super.initialize();
    }

    @Override
    public void clientInitialize() {
        this.BOSS_MUSIC = BTSoundEvents.OCEAN_GOLEM_FIGHT_MUSIC;
        this.TOWER_MUSIC = BTSoundEvents.OCEAN_TOWER_MUSIC;
        super.clientInitialize();
    }

    @Override
    public void serverInitialize() {
        this.floorDistance = -11;
        this.chestBlock = (Block)BTBlocks.OCEAN_CHEST.get();
        this.golemChestBlock = (Block)BTBlocks.OCEAN_GOLEM_CHEST.get();
        this.spawnerBlock = (Block)BTBlocks.BT_OCEAN_SPAWNER.get();
        this.spawnerFillBlock = Blocks.f_50378_;
        this.noise = (Boolean)BattleTowersConfig.minimalOceanCarving.get() != false ? 30 + (this.f_19796_.nextInt(2) + 1) * 4 : 60 + (this.f_19796_.nextInt(2) + 1) * 4;
        this.top = this.m_146904_() - 2;
        this.bottom = this.m_146904_() - 92;
        this.currentFloorY = this.top;
        this.currentCarveLayer = this.top;
        this.wallDistance = (double)this.noise - 0.5;
        this.nextStep = this.f_19796_.nextInt(4) + 8;
        this.distanceChange = this.f_19796_.nextInt(3);
        this.westWall = this.m_146903_() - this.noise;
        this.northWall = this.m_146907_() - this.noise;
        this.eastWall = this.m_146903_() + this.noise;
        this.southWall = this.m_146907_() + this.noise;
        super.serverInitialize();
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag tag) {
        tag.m_128379_("OceanCarved", this.oceanCarved);
        super.m_7380_(tag);
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.oceanCarved = tag.m_128471_("OceanCarved");
        BrassAmberBattleTowers.LOGGER.info("Ocean Carved in read data " + this.oceanCarved);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            return;
        }
        if (!this.oceanCarved && this.serverInitialized) {
            this.carveOcean();
            BTUtil.doNoOutputCommand(this, "/kill @e[type=item]");
            return;
        }
        if (this.f_19797_ % 320 <= 5 && this.hasPlayer && this.canCheck) {
            List players = Objects.requireNonNull(this.f_19853_.m_142572_()).m_6846_().m_11314_();
            for (ServerPlayer player : players) {
                if (!(BTUtil.distanceTo2D((Entity)this, (Entity)player) < (double)this.musicDistance)) continue;
                player.m_147215_(new MobEffectInstance(MobEffects.f_19608_, 320, 0, true, true), (Entity)player);
                player.m_147215_(new MobEffectInstance(MobEffects.f_19596_, 220, 1, true, true), (Entity)player);
                player.m_147215_(new MobEffectInstance((MobEffect)BTExtras.DEPTH_DROPPER_EFFECT.get(), 160, 2, true, true), (Entity)player);
            }
        }
    }

    public void carveOcean() {
        BrassAmberBattleTowers.LOGGER.info("Round of carving: " + this.currentCarveLayer);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        if (this.currentCarveLayer >= this.bottom) {
            int bottomRange = this.currentCarveLayer + this.floorDistance;
            if (this.currentCarveLayer - this.bottom < 20) {
                bottomRange = this.bottom;
            }
            for (int y = this.currentCarveLayer; y >= bottomRange; --y) {
                if (y == this.bottom + 33) {
                    this.wallDistance = ((Boolean)BattleTowersConfig.minimalOceanCarving.get()).booleanValue() ? (this.wallDistance -= 2.0) : (this.wallDistance -= 10.0);
                } else if ((this.top - y) % this.nextStep == 0) {
                    this.wallDistance -= (double)this.distanceChange;
                    this.nextStep = this.f_19796_.nextInt(4) + 8;
                    this.distanceChange = y > this.bottom + 33 ? this.f_19796_.nextInt(3) : this.f_19796_.nextInt(2) + 1;
                }
                if (y > this.bottom) {
                    for (int x = this.westWall; x <= this.eastWall; ++x) {
                        for (int z = this.northWall; z <= this.southWall; ++z) {
                            blockpos$mutableblockpos.m_122178_(x, y, z);
                            Block block = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_();
                            double distance2d = BTUtil.distanceTo2D((Entity)this, (BlockPos)blockpos$mutableblockpos);
                            if (y <= this.bottom) continue;
                            if (distance2d > 15.5) {
                                if (this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() == Blocks.f_50576_) {
                                    this.f_19853_.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_49990_.m_49966_(), 3);
                                    continue;
                                }
                                if (this.f_19853_.m_46801_((BlockPos)blockpos$mutableblockpos)) continue;
                                if (distance2d < this.wallDistance - 2.0) {
                                    this.f_19853_.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_49990_.m_49966_(), 2);
                                    continue;
                                }
                                if (distance2d < this.wallDistance - 1.0) {
                                    if (this.f_19796_.nextInt(50) > 30) {
                                        this.f_19853_.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50493_.m_49966_(), 2);
                                        continue;
                                    }
                                    this.f_19853_.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_49994_.m_49966_(), 2);
                                    continue;
                                }
                                if (!(distance2d < this.wallDistance) || this.avoidBlocks.contains(block)) continue;
                                this.f_19853_.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50493_.m_49966_(), 2);
                                continue;
                            }
                            if (this.avoidBlocks.contains(block)) continue;
                            this.f_19853_.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_49990_.m_49966_(), 2);
                        }
                    }
                    continue;
                }
                if (y != this.bottom) continue;
                this.addCoral();
            }
            this.currentCarveLayer = bottomRange;
        }
        if (this.currentCarveLayer == this.bottom) {
            this.oceanCarved = true;
        }
        BrassAmberBattleTowers.LOGGER.info("Ocean Carved : " + this.oceanCarved);
    }

    public void addCoral() {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int y = this.top; y > this.bottom - 1; --y) {
            for (int x = this.westWall; x <= this.eastWall; ++x) {
                for (int z = this.northWall; z <= this.southWall; ++z) {
                    blockpos$mutableblockpos.m_122178_(x, y, z);
                    BlockPos blockAbove = blockpos$mutableblockpos.m_7494_();
                    double distance2d = BTUtil.distanceTo2D((Entity)this, (BlockPos)blockpos$mutableblockpos);
                    if (!(distance2d > 13.0) || this.f_19853_.m_46801_((BlockPos)blockpos$mutableblockpos) || !this.f_19853_.m_46801_(blockAbove)) continue;
                    int vegetation = this.f_19796_.nextInt(75);
                    if (vegetation > 55) {
                        this.f_19853_.m_7731_(blockAbove, Blocks.f_50037_.m_49966_(), 2);
                        continue;
                    }
                    if (vegetation > 40) {
                        this.f_19853_.m_7731_(blockAbove, this.corals.get(this.f_19796_.nextInt(5)), 2);
                        continue;
                    }
                    this.f_19853_.m_7731_(blockAbove, Blocks.f_49990_.m_49966_(), 2);
                }
            }
        }
    }
}

