/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.entity.block;

import com.BrassAmber.ba_bt.BrassAmberBattleTowers;
import com.BrassAmber.ba_bt.block.block.BTSpawnerBlock;
import com.BrassAmber.ba_bt.block.blockentity.GolemChestBlockEntity;
import com.BrassAmber.ba_bt.block.blockentity.TowerChestBlockEntity;
import com.BrassAmber.ba_bt.block.blockentity.spawner.BTAbstractSpawnerBlockEntity;
import com.BrassAmber.ba_bt.entity.block.BTMonolith;
import com.BrassAmber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import com.BrassAmber.ba_bt.init.BTBlocks;
import com.BrassAmber.ba_bt.item.item.ResonanceStoneItem;
import com.BrassAmber.ba_bt.util.BTLoot;
import com.BrassAmber.ba_bt.util.BTStatics;
import com.BrassAmber.ba_bt.util.BTUtil;
import com.BrassAmber.ba_bt.util.GolemType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BTAbstractObelisk
extends Entity {
    private static final EntityDataAccessor<Integer> SPAWNERS_DESTROYED = SynchedEntityData.m_135353_(BTAbstractObelisk.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private List<BlockPos> CHESTS = new ArrayList<BlockPos>(9);
    private List<List<BlockPos>> SPAWNERS;
    private List<Integer> spawnerAmounts;
    private List<Integer> keySpawnerAmounts;
    protected List<EntityType<?>> towerMobs;
    private boolean initialized = false;
    protected boolean clientInitialized = false;
    protected boolean serverInitialized = false;
    protected int checkLayer = 1;
    protected int currentFloorY;
    private boolean doCheck;
    protected MusicManager music;
    protected int musicDistance;
    protected int towerRange;
    protected GolemType golemType;
    private boolean justSpawnedKey;
    public Music TOWER_MUSIC;
    public Music BOSS_MUSIC;
    private final String towerName = "Tower";
    private final String spawnersDestroyedName = "SpawnersDestroyed";
    protected boolean musicPlaying;
    protected boolean canCheck;
    private boolean golemSpawned = false;
    private Class<? extends Entity> specialEnemy;
    private boolean chestsFound;
    public boolean hasPlayer;
    protected int floorDistance;
    protected boolean floorChestFound;
    protected Block chestBlock;
    protected Block golemChestBlock;
    protected Block spawnerBlock;
    protected Block spawnerFillBlock;
    protected Block spawnerMarker;
    protected List<List<Integer>> perFloorData;
    protected List<Integer> floorData;
    protected GolemChestBlockEntity golemChest;

    public BTAbstractObelisk(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
        this.musicPlaying = false;
        this.doCheck = true;
        this.hasPlayer = false;
        this.canCheck = true;
        this.musicDistance = 0;
        this.towerRange = 0;
        this.floorChestFound = false;
    }

    public BTAbstractObelisk(GolemType golemType, Level level) {
        this(GolemType.getObeliskFor(golemType), level);
        this.golemType = golemType;
        this.chestsFound = false;
    }

    public void initialize() {
        this.initialized = true;
    }

    public void clientInitialize() {
        ClientLevel client = (ClientLevel)this.f_19853_;
        this.music = client.f_104565_.m_91397_();
        this.clientInitialized = true;
    }

    public void serverInitialize() {
        int golemNum = GolemType.getNumForType(this.golemType);
        this.keySpawnerAmounts = BTStatics.towerChestUnlocking.get(golemNum);
        this.spawnerAmounts = BTStatics.towerSpawnerAmounts.get(golemNum);
        if (!this.chestsFound) {
            this.SPAWNERS = Arrays.asList(new ArrayList(this.spawnerAmounts.get(0)), new ArrayList(this.spawnerAmounts.get(1)), new ArrayList(this.spawnerAmounts.get(2)), new ArrayList(this.spawnerAmounts.get(3)), new ArrayList(this.spawnerAmounts.get(4)), new ArrayList(this.spawnerAmounts.get(5)), new ArrayList(this.spawnerAmounts.get(6)), new ArrayList(this.spawnerAmounts.get(7)));
        }
        this.specialEnemy = GolemType.getSpecialEnemyClass(this.golemType);
        this.towerMobs = BTStatics.towerMobs.get(golemNum);
        this.perFloorData = BTStatics.towerSpawnerData.get(golemNum);
        this.floorData = this.perFloorData.get(0);
        this.spawnerMarker = (Block)BTBlocks.BT_SPAWNER_MARKER.get();
        this.serverInitialized = true;
    }

    public void findChestsAndSpawners(Level level) {
        BlockPos center = this.m_20097_();
        int nextFloorY = this.checkLayer == 8 ? this.currentFloorY + this.floorDistance + this.floorDistance : this.currentFloorY + this.floorDistance;
        BlockPos corner = center.m_142082_(-15, 0, -15);
        BlockPos oppositeCorner = center.m_142082_(15, 0, 15);
        int spawnersSet = 0;
        int bottomOfFloor = Math.min(this.currentFloorY, nextFloorY);
        int topOfFloor = Math.max(this.currentFloorY, nextFloorY);
        for (int x = corner.m_123341_(); x < oppositeCorner.m_123341_(); ++x) {
            for (int z = corner.m_123343_(); z < oppositeCorner.m_123343_(); ++z) {
                for (int y = bottomOfFloor; y <= topOfFloor; ++y) {
                    BlockPos toCheck = new BlockPos(x, y, z);
                    if (level.m_8055_(toCheck).m_60734_() == this.spawnerMarker) {
                        spawnersSet = this.setSpawnerBlock(toCheck, this.checkLayer, level, spawnersSet);
                    }
                    this.checkPos(toCheck, level);
                    this.extraCheck(toCheck, level);
                }
            }
        }
        if (this.CHESTS.size() != this.checkLayer) {
            this.CHESTS.add(null);
        }
        if (this.checkLayer == 8) {
            this.chestsFound = true;
        } else {
            ++this.checkLayer;
            if (this.checkLayer % 2 == 0 && this.checkLayer < 8) {
                this.floorData = this.perFloorData.get(this.checkLayer / 2);
            }
            this.currentFloorY = nextFloorY;
            this.floorChestFound = false;
        }
    }

    protected int setSpawnerBlock(BlockPos pos, int floor, Level level, int spawnersSet) {
        if (spawnersSet < this.spawnerAmounts.get(floor - 1)) {
            level.m_7731_(pos, this.spawnerBlock.m_49966_(), 2);
            return spawnersSet + 1;
        }
        level.m_7731_(pos, this.spawnerFillBlock.m_49966_(), 2);
        return spawnersSet;
    }

    public void checkPos(BlockPos toCheck, Level level) {
        try {
            Block block = level.m_8055_(toCheck).m_60734_();
            if (block == this.chestBlock && !this.floorChestFound) {
                this.CHESTS.add(toCheck);
                this.floorChestFound = true;
            } else if (block == this.spawnerBlock || block == Blocks.f_50085_) {
                this.SPAWNERS.get(this.checkLayer - 1).add(toCheck);
                BlockEntity entity = this.f_19853_.m_7702_(toCheck);
                if (entity instanceof BTAbstractSpawnerBlockEntity) {
                    BTAbstractSpawnerBlockEntity btspawnerEntity = (BTAbstractSpawnerBlockEntity)entity;
                    btspawnerEntity.getSpawner().setBtSpawnData(this.towerMobs.get(this.f_19796_.nextInt(this.towerMobs.size())), this.floorData.get(0), this.floorData.get(1), this.floorData.get(2), this.floorData.get(3), this.floorData.get(4), this.floorData.get(5));
                }
            } else if (block == this.golemChestBlock) {
                this.golemChest = (GolemChestBlockEntity)level.m_7702_(toCheck);
            }
        }
        catch (Exception e) {
            BrassAmberBattleTowers.LOGGER.info("Exception in Obelisk class, not a chest or spawner: " + level.m_8055_(toCheck).m_60734_());
            e.printStackTrace();
        }
    }

    public void extraCheck(BlockPos toUpdate, Level level) {
    }

    public void m_8119_() {
        block24: {
            super.m_8119_();
            if (!this.initialized) {
                this.initialize();
                return;
            }
            if (this.f_19853_.m_5776_()) {
                this.clientTick();
                return;
            }
            if (!this.serverInitialized) {
                this.serverInitialize();
                return;
            }
            if (!this.chestsFound) {
                this.findChestsAndSpawners(this.f_19853_);
            }
            if (this.doCheck) {
                try {
                    List list = this.f_19853_.m_45976_(BTMonolith.class, this.m_142469_().m_82377_(15.0, 110.0, 15.0));
                    boolean bl = this.canCheck = list.size() != 0;
                    if (this.canCheck) break block24;
                    try {
                        List list2 = this.f_19853_.m_45976_(BTAbstractGolem.class, this.m_142469_().m_82377_(15.0, 110.0, 15.0));
                        boolean bl2 = this.canCheck = list2.size() != 0;
                        if (!this.golemSpawned) {
                            this.golemSpawned = true;
                        }
                    }
                    catch (Exception f) {
                        BrassAmberBattleTowers.LOGGER.error("Exception finding Golem: " + f);
                    }
                }
                catch (Exception e) {
                    BrassAmberBattleTowers.LOGGER.error("Exception finding Monolith: " + e);
                }
            }
        }
        if (this.canCheck) {
            List specialEnemies;
            List players = Objects.requireNonNull(this.f_19853_.m_142572_()).m_6846_().m_11314_();
            ArrayList<Boolean> playersClose = new ArrayList<Boolean>();
            for (ServerPlayer player : players) {
                if (BTUtil.distanceTo2D((Entity)this, (Entity)player) < (double)this.towerRange) {
                    playersClose.add(Boolean.TRUE);
                    continue;
                }
                playersClose.add(Boolean.FALSE);
            }
            this.hasPlayer = Collections.frequency(playersClose, Boolean.TRUE) > 0;
            int timeCheck = (this.f_19796_.nextInt(2) + 4) * 10;
            if (this.f_19797_ % timeCheck == 0 && (specialEnemies = this.f_19853_.m_45976_(this.specialEnemy, this.m_142469_().m_82377_(15.0, 110.0, 15.0))).size() < 10) {
                int floor = this.m_142538_().m_123342_() + this.f_19796_.nextInt(8) * 11;
                int x = this.m_142538_().m_123341_() + this.f_19796_.nextInt(24) - 12;
                int y = floor + this.f_19796_.nextInt(9);
                int z = this.m_142538_().m_123343_() + this.f_19796_.nextInt(24) - 12;
                ServerLevel serverWorld = (ServerLevel)this.f_19853_;
                switch (this.golemType) {
                    case LAND: {
                        this.spawnSpecialEnemy(serverWorld, new BlockPos(x, y, z), 0.0, 11.5, true);
                        break;
                    }
                    case OCEAN: {
                        this.spawnSpecialEnemy(serverWorld, new BlockPos(x, y, z), 12.5, 17.5, false);
                        break;
                    }
                    case CORE: {
                        this.spawnSpecialEnemy(serverWorld, new BlockPos(x, y, z), 12.5, 17.5, true);
                    }
                }
            }
            if (this.f_19797_ % 20 == 0 && this.hasPlayer) {
                this.checkSpawners(this.f_19853_);
            }
        } else if (this.golemChest != null && this.chestsFound && this.initialized && this.f_19797_ > 40 && !this.golemChest.isUnlocked()) {
            try {
                BrassAmberBattleTowers.LOGGER.log(org.apache.logging.log4j.Level.DEBUG, "Chest " + this.golemChest);
                this.golemChest.setUnlocked(true);
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.golemChest.m_58899_())).m_78965_(this.f_19796_.nextLong());
                BTLoot.getGolemLootTable(GolemType.getNumForType(this.golemType)).m_79123_((Container)this.golemChest, lootcontext$builder.m_78975_(LootContextParamSets.f_81411_));
                this.chestUnlockingSound(this.f_19853_);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clientTick() {
        boolean playerInMusicRange;
        boolean playerInTowerRange;
        boolean hasClientPlayer;
        ClientLevel client;
        block17: {
            client = (ClientLevel)this.f_19853_;
            if (!this.clientInitialized) {
                this.clientInitialize();
            }
            if (client.m_6907_().size() == 0) {
                return;
            }
            if (this.doCheck) {
                try {
                    List list = client.m_45976_(BTMonolith.class, this.m_142469_().m_82377_(15.0, 110.0, 15.0));
                    boolean bl = this.canCheck = list.size() != 0;
                    if (this.canCheck) break block17;
                    try {
                        List list2 = this.f_19853_.m_45976_(BTAbstractGolem.class, this.m_142469_().m_82377_(15.0, 110.0, 15.0));
                        boolean bl2 = this.canCheck = list2.size() != 0;
                        if (!this.golemSpawned) {
                            this.golemSpawned = true;
                        }
                    }
                    catch (Exception f) {
                        BrassAmberBattleTowers.LOGGER.error("Exception finding Golem: " + f);
                    }
                }
                catch (Exception e) {
                    BrassAmberBattleTowers.LOGGER.error("Exception finding Monolith: " + e);
                }
            }
        }
        if ((hasClientPlayer = client.m_45914_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 100.0)) && !this.golemSpawned) {
            playerInTowerRange = BTUtil.distanceTo2D((Entity)this, (Entity)client.m_45930_((Entity)this, 100.0)) <= (double)this.towerRange;
            playerInMusicRange = BTUtil.distanceTo2D((Entity)this, (Entity)client.m_45930_((Entity)this, 100.0)) < (double)this.musicDistance;
        } else {
            playerInTowerRange = false;
            playerInMusicRange = false;
        }
        boolean tryPlayMusic = false;
        if (this.BOSS_MUSIC == null) {
            tryPlayMusic = playerInTowerRange;
        } else if (!this.music.m_120187_(this.BOSS_MUSIC)) {
            tryPlayMusic = playerInTowerRange;
        }
        if (tryPlayMusic) {
            if (playerInMusicRange && !this.music.m_120187_(this.TOWER_MUSIC)) {
                this.music.m_120186_();
                this.music.f_120180_ = this.TOWER_MUSIC.m_11636_();
                this.music.m_120184_(this.TOWER_MUSIC);
                this.musicPlaying = true;
            }
        } else if (this.musicPlaying) {
            this.music.f_120180_ = 500;
            this.music.m_120186_();
            this.musicPlaying = false;
        }
    }

    protected void spawnSpecialEnemy(ServerLevel serverWorld, BlockPos spawn, double lowerRadiusBound, double upperRadiusBound, boolean checkOnGround) {
        Entity entity;
        boolean acceptableDistance;
        double distance = BTUtil.distanceTo2D(this, spawn.m_123341_(), spawn.m_123343_());
        boolean canSpawn = SpawnPlacements.m_21759_(GolemType.getSpecialEnemyType(this.golemType), (ServerLevelAccessor)serverWorld, (MobSpawnType)MobSpawnType.STRUCTURE, (BlockPos)spawn, (Random)this.f_19796_);
        boolean bl = acceptableDistance = lowerRadiusBound < distance && distance < upperRadiusBound;
        boolean onGround = checkOnGround ? !serverWorld.m_8055_(spawn.m_7495_()).m_60795_() && serverWorld.m_8055_(spawn).m_60795_() : true;
        if (canSpawn && acceptableDistance && onGround && serverWorld.m_8055_(spawn.m_7494_()).m_60795_() && (entity = GolemType.getSpecialEnemy(this.golemType, serverWorld)) instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6034_((double)spawn.m_123341_(), (double)spawn.m_123342_(), (double)spawn.m_123343_());
            mob.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(this.m_142538_()), MobSpawnType.TRIGGERED, null, null);
            serverWorld.m_7967_(entity);
        }
    }

    private void checkSpawners(Level level) {
        if (this.SPAWNERS.size() == 0 || this.CHESTS.size() == 0) {
            this.doCheck = false;
            this.canCheck = false;
        } else {
            for (int i = 0; i < this.SPAWNERS.size(); ++i) {
                BlockEntity blockEntity;
                if (this.SPAWNERS.get(i).size() == 0) {
                    TowerChestBlockEntity chest;
                    BlockEntity blockEntity2;
                    BlockPos chestPos = this.CHESTS.get(i);
                    if (chestPos == null || !((blockEntity2 = level.m_7702_(chestPos)) instanceof TowerChestBlockEntity) || (chest = (TowerChestBlockEntity)blockEntity2).isUnlocked()) continue;
                    chest.setUnlocked(true);
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)chestPos)).m_78965_(this.f_19796_.nextLong());
                    assert (chest != null) : "BTObelisk: Not a BTChest";
                    BTUtil.btFill(BTLoot.getLootTable(GolemType.getNumForType(this.golemType), i), (Container)chest, lootcontext$builder.m_78975_(LootContextParamSets.f_81411_));
                    this.chestUnlockingSound(level);
                    this.CHESTS.set(i, null);
                    continue;
                }
                List<BlockPos> poss = this.SPAWNERS.get(i);
                for (int x = 0; x < poss.size(); ++x) {
                    BlockPos blockPos = poss.get(x);
                    if (level.m_8055_(blockPos).m_60734_() instanceof BTSpawnerBlock) continue;
                    this.SPAWNERS.get(i).remove(blockPos);
                    this.setSpawnersDestroyed(this.getSpawnersDestroyed() + 1);
                    BrassAmberBattleTowers.LOGGER.info("Spawners Destroyed: " + this.getSpawnersDestroyed());
                    if (!this.justSpawnedKey) continue;
                    this.justSpawnedKey = false;
                }
                if (!this.keySpawnerAmounts.contains(this.getSpawnersDestroyed()) || this.justSpawnedKey) continue;
                if (this.CHESTS.get(i) != null && (blockEntity = level.m_7702_(this.CHESTS.get(i))) instanceof TowerChestBlockEntity) {
                    TowerChestBlockEntity chest = (TowerChestBlockEntity)blockEntity;
                    chest.m_6836_(13, GolemType.getKeyFor(this.golemType).m_7968_());
                } else if (this.CHESTS.get(i) != null) {
                    BTUtil.doNoOutputPostionedCommand(this, "give @p ba_bt:" + GolemType.getKeyFor(this.golemType).getRegistryName(), new Vec3((double)this.m_142538_().m_123341_(), (double)(this.m_142538_().m_123342_() + 11 * i), (double)this.m_142538_().m_123343_()));
                    this.CHESTS.set(i, null);
                }
                this.justSpawnedKey = true;
            }
        }
    }

    private void chestUnlockingSound(Level level) {
        List players = Objects.requireNonNull(level.m_142572_()).m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            if (!(BTUtil.distanceTo2D((Entity)this, (Entity)player) < 30.0)) continue;
            level.m_5594_(null, player.m_142538_(), SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, 1.5f);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPAWNERS_DESTROYED, (Object)0);
    }

    protected void m_7378_(CompoundTag tag) {
        if (!this.f_19853_.m_5776_()) {
            this.golemType = GolemType.getTypeForName(tag.m_128461_("Tower"));
            this.setSpawnersDestroyed(tag.m_128451_("SpawnersDestroyed"));
        }
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        if (this.f_19853_.m_5776_()) {
            ((ClientLevel)this.f_19853_).f_104565_.m_91397_().m_120186_();
        } else {
            BrassAmberBattleTowers.LOGGER.info("Setting obelisk data");
            tag.m_128359_("Tower", this.golemType.m_7912_());
            tag.m_128405_("SpawnersDestroyed", this.getSpawnersDestroyed());
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)((Item)null));
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.BLOCK;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public boolean m_5829_() {
        return true;
    }

    public void m_6074_() {
        Player player = this.f_19853_.m_5788_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 50.0, EntitySelector.f_20408_);
        if (player != null && player.m_7500_()) {
            BrassAmberBattleTowers.LOGGER.info("Item: " + player.m_21120_(InteractionHand.MAIN_HAND).m_41720_());
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.f_42461_) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            } else {
                BrassAmberBattleTowers.LOGGER.info("Used the /kill command. However, an Obelisk has been saved at: " + Math.round(this.m_20185_()) + "X " + Math.round(this.m_20186_()) + "Y " + Math.round(this.m_20189_()) + "Z.");
            }
        } else {
            BrassAmberBattleTowers.LOGGER.info("Used the /kill command. However, an Obelisk has been saved at: " + Math.round(this.m_20185_()) + "X " + Math.round(this.m_20186_()) + "Y " + Math.round(this.m_20189_()) + "Z.");
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Player player;
        if (this.m_6673_(source)) {
            return false;
        }
        if (!source.m_19385_().equals("player")) {
            return false;
        }
        if (this.m_6084_() && !this.f_19853_.m_5776_() && source.m_19390_() && (player = (Player)source.m_7639_()) != null && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.f_42461_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        return true;
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        Item item = itemInHand.m_41720_();
        if (item instanceof ResonanceStoneItem) {
            ResonanceStoneItem stoneItem = (ResonanceStoneItem)item;
            stoneItem.addEnchantment(itemInHand);
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.AMBIENT;
    }

    public void setSpawnersDestroyed(int num) {
        this.f_19804_.m_135381_(SPAWNERS_DESTROYED, (Object)num);
    }

    public int getSpawnersDestroyed() {
        return (Integer)this.f_19804_.m_135370_(SPAWNERS_DESTROYED);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

