/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.entity.ai.goal.oceangolem;

import com.BrassAmber.ba_bt.entity.hostile.golem.BTOceanGolem;
import com.BrassAmber.ba_bt.util.BTUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class DashAttackGoal
extends Goal {
    private final BTOceanGolem mob;
    @Nullable
    private LivingEntity target;
    private BlockPos wantedPos;
    private final double speedModifier;
    private final int range;
    protected static final int WARMUP_TICKS = 60;
    private int warmup = 60;

    public DashAttackGoal(BTOceanGolem golem, int range) {
        this.mob = golem;
        this.speedModifier = 0.7;
        this.range = range;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        if (this.target != null && this.target.m_6084_() && BTUtil.distanceTo2D((Entity)this.mob, (Entity)this.target) > 10.0) {
            --this.warmup;
            return this.warmup <= 0;
        }
        return false;
    }

    public boolean m_8045_() {
        this.target = this.mob.m_5448_();
        double currentX = this.mob.m_20185_();
        double currentZ = this.mob.m_20189_();
        if (this.target != null && this.target.m_6084_()) {
            return currentX != (double)this.wantedPos.m_123341_() && currentZ != (double)this.wantedPos.m_123343_();
        }
        return false;
    }

    public void m_8041_() {
        this.target = null;
        this.warmup = 60;
    }

    public void m_8056_() {
        this.target = this.mob.m_5448_();
        int wantedDistance = this.range;
        this.wantedPos = this.getNewPos(wantedDistance);
        while (!this.mob.f_19853_.m_46801_(this.wantedPos)) {
            this.wantedPos = this.getNewPos(--wantedDistance);
        }
        this.mob.m_21573_().m_26519_((double)this.wantedPos.m_123341_(), (double)this.wantedPos.m_123342_(), (double)this.wantedPos.m_123343_(), this.speedModifier);
    }

    public BlockPos getNewPos(int distance) {
        BlockPos targetPos = this.target.m_142538_();
        double ratio = BTUtil.distanceTo3D((Entity)this.mob, (Entity)this.target) / (double)distance;
        double xVal = (double)(targetPos.m_123341_() - this.mob.m_146903_()) * ratio;
        double yVal = (double)(targetPos.m_123342_() - this.mob.m_146904_()) * ratio;
        double zVal = (double)(targetPos.m_123343_() - this.mob.m_146907_()) * ratio;
        this.wantedPos = this.mob.m_142538_().m_142022_(xVal, yVal, zVal);
        return this.wantedPos;
    }
}

