/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.entity.ai.goal;

import com.BrassAmber.ba_bt.entity.hostile.golem.BTAbstractGolem;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GolemStompAttackGoal
extends Goal {
    protected final BTAbstractGolem golem;
    protected final float explosionStrength;
    protected final double minVertDistance;
    protected boolean jumpingInProgress = false;
    protected static final int WARMUP_TICKS = 10;
    protected int warmup = 10;

    public GolemStompAttackGoal(BTAbstractGolem golem, float explosionStrength, double minVertDistToTarget) {
        this.golem = golem;
        this.explosionStrength = explosionStrength;
        this.minVertDistance = minVertDistToTarget;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_8036_() {
        if (this.golem.m_5448_() != null && !this.golem.isDormant() && this.golem.m_20096_()) {
            LivingEntity target = this.golem.m_5448_();
            Vec3 targetPos = target.m_20182_();
            Vec3 golemPos = this.golem.m_20182_();
            double distHorizontal = Math.abs((targetPos.f_82479_ - golemPos.f_82479_) * (targetPos.f_82479_ - golemPos.f_82479_) + (targetPos.f_82481_ - golemPos.f_82481_) * (targetPos.f_82481_ - golemPos.f_82481_));
            double distVertical = golemPos.f_82480_ - targetPos.f_82480_;
            if (distVertical <= this.minVertDistance) {
                return false;
            }
            if (distHorizontal > this.minVertDistance * 5.0) {
                return false;
            }
            --this.warmup;
            return this.warmup <= 0;
        }
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.golem.m_20256_(Vec3.f_82478_);
        this.golem.m_20256_(Vec3.f_82478_.m_82520_(0.0, (double)(this.explosionStrength / 3.0f), 0.0));
        this.jumpingInProgress = true;
    }

    public void m_8037_() {
        super.m_8037_();
        if (!this.golem.m_20096_() && !this.jumpingInProgress) {
            this.jumpingInProgress = true;
        } else if (this.jumpingInProgress && this.golem.m_20096_()) {
            this.jumpingInProgress = false;
            AABB aabb = new AABB(this.golem.m_20182_().m_82520_((double)this.golem.m_20205_(), 1.0, (double)this.golem.m_20205_()), this.golem.m_20182_().m_82492_((double)this.golem.m_20205_(), 2.0, (double)this.golem.m_20205_()));
            BlockPos.MutableBlockPos.m_121921_((AABB)aabb).forEach(position -> this.golem.f_19853_.m_46961_(position, true));
            Vec3 position2 = this.golem.m_20182_();
            this.golem.f_19853_.m_46511_((Entity)this.golem, position2.f_82479_, position2.f_82480_ - 1.0, position2.f_82481_, this.explosionStrength, Explosion.BlockInteraction.BREAK);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.warmup = 10;
    }

    public boolean m_8045_() {
        return this.jumpingInProgress;
    }
}

