/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.client.renderer.monolith;

import com.BrassAmber.ba_bt.BrassAmberBattleTowers;
import com.BrassAmber.ba_bt.client.model.block.MonolithModel;
import com.BrassAmber.ba_bt.entity.block.BTMonolith;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class MonolithRendererAbstract
extends EntityRenderer<BTMonolith> {
    private final MonolithModel monolith;
    private List<ResourceLocation> monolithTextures = Lists.newArrayList();
    private List<ModelLayerLocation> monolithLayers = Lists.newArrayList();
    private String monolithType;

    public MonolithRendererAbstract(EntityRendererProvider.Context context, String monolithType, ModelLayerLocation location) {
        super(context);
        this.monolithType = monolithType;
        this.setMonolithTextures();
        this.monolith = new MonolithModel(context.m_174023_(location), location);
    }

    public void render(BTMonolith entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float speedModifier = 32.0f;
        float amplitude = 0.25f;
        float defaultHeight = 0.5f;
        float floatingInput = entityIn.getFloatingRotation() / speedModifier;
        float floatingWave = amplitude * Mth.m_14031_((float)floatingInput) + defaultHeight;
        matrixStackIn.m_85837_(0.0, (double)floatingWave, 0.0);
        float yaw = entityIn.m_146908_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(yaw));
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStackIn.m_85837_(0.0, -2.0, 0.0);
        matrixStackIn.m_85837_(0.0, 0.5, 0.0);
        VertexConsumer vertexConsumer = bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(entityIn)));
        this.monolith.m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(BTMonolith entityIn) {
        int eyeSlotIncrement = entityIn.isEyeSlotDisplayed() ? 1 : 0;
        int textureLocation = entityIn.getKeyCountInEntity() + eyeSlotIncrement;
        return this.getMonolithTexture(textureLocation);
    }

    private ResourceLocation getMonolithTexture(int textureLocation) {
        int maxAmountOfTextures = this.isLandMonolith() ? 3 : 4;
        return this.monolithTextures.get(Mth.m_14045_((int)textureLocation, (int)0, (int)maxAmountOfTextures));
    }

    private void setMonolithTextures() {
        int maxTextures = this.isLandMonolith() ? 3 : 4;
        for (int x = 0; x <= maxTextures; ++x) {
            ResourceLocation textureLocation = this.setMonolithTextureLocation(this.monolithType + "_" + x);
            this.monolithTextures.add(textureLocation);
            this.monolithLayers.add(new ModelLayerLocation(textureLocation, "main"));
        }
    }

    private ResourceLocation setMonolithTextureLocation(String textureName) {
        return BrassAmberBattleTowers.locate("textures/entity/monolith/" + this.monolithType + "/" + textureName + ".png");
    }

    private boolean isLandMonolith() {
        return this.monolithType.equals("land_monolith");
    }
}

