/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.client.renderer.chest;

import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class BTChestBlockEntityRendererAbstract
extends ChestRenderer<ChestBlockEntity> {
    private final Material singleChest;
    private final Material doubleChestLeft;
    private final Material doubleChestRight;

    public BTChestBlockEntityRendererAbstract(BlockEntityRendererProvider.Context context, ResourceLocation[] chestTextureLocations) {
        super(context);
        this.singleChest = BTChestBlockEntityRendererAbstract.chestMaterial(chestTextureLocations[0]);
        this.doubleChestLeft = BTChestBlockEntityRendererAbstract.chestMaterial(chestTextureLocations[1]);
        this.doubleChestRight = BTChestBlockEntityRendererAbstract.chestMaterial(chestTextureLocations[2]);
    }

    @NotNull
    protected Material getMaterial(@NotNull ChestBlockEntity tileEntity, @NotNull ChestType chestType) {
        return BTChestBlockEntityRendererAbstract.chooseMaterial(chestType, this.singleChest, this.doubleChestLeft, this.doubleChestRight);
    }

    private static Material chestMaterial(ResourceLocation chestTextureLocation) {
        return new Material(Sheets.f_110740_, chestTextureLocation);
    }

    private static Material chooseMaterial(ChestType chestType, Material renderMaterialSingle, Material renderMaterialLeft, Material renderMaterialRight) {
        switch (chestType) {
            case LEFT: {
                return renderMaterialLeft;
            }
            case RIGHT: {
                return renderMaterialRight;
            }
        }
        return renderMaterialSingle;
    }
}

