/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.client;

import com.BrassAmber.ba_bt.BrassAmberBattleTowers;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ba_bt", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BTChestTextures {
    public static final ResourceLocation[] LAND_GOLEM_CHEST_TEXTURES = BTChestTextures.locateChestTextures("golem", "land_golem");
    public static final ResourceLocation[] LAND_CHEST_TEXTURES = BTChestTextures.locateChestTextures("tower", "land");
    public static final ResourceLocation[] OCEAN_GOLEM_CHEST_TEXTURES = BTChestTextures.locateChestTextures("golem", "ocean_golem");
    public static final ResourceLocation[] OCEAN_CHEST_TEXTURES = BTChestTextures.locateChestTextures("tower", "ocean");

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void textureStitch(TextureStitchEvent.Pre event) {
        BTChestTextures.stitchAll(event, LAND_GOLEM_CHEST_TEXTURES);
        BTChestTextures.stitchAll(event, LAND_CHEST_TEXTURES);
        BTChestTextures.stitchAll(event, OCEAN_GOLEM_CHEST_TEXTURES);
        BTChestTextures.stitchAll(event, OCEAN_CHEST_TEXTURES);
    }

    private static void stitchAll(TextureStitchEvent.Pre event, ResourceLocation[] textureLocations) {
        for (ResourceLocation chestTexture : textureLocations) {
            event.addSprite(chestTexture);
        }
    }

    private static ResourceLocation[] locateChestTextures(String chestType, String chestName) {
        return new ResourceLocation[]{BrassAmberBattleTowers.locate("entity/chest/" + chestType + "_chest/" + chestName), BrassAmberBattleTowers.locate("entity/chest/" + chestType + "_chest/" + chestName + "_left"), BrassAmberBattleTowers.locate("entity/chest/" + chestType + "_chest/" + chestName + "_right")};
    }

    public static ModelLayerLocation locateChestLayer(String chestType, String chestName, int side) {
        if (side == 0) {
            return new ModelLayerLocation(BrassAmberBattleTowers.locate("entity/chest/" + chestType + "_chest/" + chestName), "main");
        }
        if (side == 1) {
            return new ModelLayerLocation(BrassAmberBattleTowers.locate("entity/chest/" + chestType + "_chest/" + chestName + "_left"), "main");
        }
        if (side == 2) {
            return new ModelLayerLocation(BrassAmberBattleTowers.locate("entity/chest/" + chestType + "_chest/" + chestName + "_right"), "main");
        }
        return null;
    }
}

