/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.block.blockentity;

import com.BrassAmber.ba_bt.BrassAmberBattleTowers;
import com.BrassAmber.ba_bt.block.block.GolemChestBlock;
import com.BrassAmber.ba_bt.util.BTUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class GolemChestBlockEntity
extends ChestBlockEntity {
    protected final String tower_name;
    private LockCode lockKey = new LockCode("bt_spawner");
    protected boolean unlocked = false;
    private static final int EVENT_SET_OPEN_COUNT = 1;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
            GolemChestBlockEntity.playSound(level, blockPos, blockState, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
            GolemChestBlockEntity.playSound(level, blockPos, blockState, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int i, int i1) {
            GolemChestBlockEntity.this.m_142151_(level, blockPos, blockState, i, i1);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ChestMenu)) {
                return false;
            }
            Container container = ((ChestMenu)player.f_36096_).m_39261_();
            return container == GolemChestBlockEntity.this || container instanceof CompoundContainer && ((CompoundContainer)container).m_18927_((Container)GolemChestBlockEntity.this);
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();

    protected GolemChestBlockEntity(BlockEntityType<? extends ChestBlockEntity> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.tower_name = BTUtil.getTowerName(blockEntityType);
    }

    public GolemChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(BTUtil.getChestEntity(blockState.m_60734_()), blockPos, blockState);
    }

    public int m_6643_() {
        return 36;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.ba_bt." + this.tower_name + "_golem_chest");
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compoundTag)) {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        }
        this.unlocked = compoundTag.m_128471_("Unlocked");
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (!this.m_59634_(compoundTag)) {
            ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        }
        compoundTag.m_128379_("Unlocked", this.unlocked);
    }

    static void playSound(Level p_155339_, BlockPos p_155340_, BlockState p_155341_, SoundEvent p_155342_) {
        ChestType chesttype = (ChestType)p_155341_.m_61143_((Property)ChestBlock.f_51479_);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)p_155340_.m_123341_() + 0.5;
            double d1 = (double)p_155340_.m_123342_() + 0.5;
            double d2 = (double)p_155340_.m_123343_() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                Direction direction = ChestBlock.m_51584_((BlockState)p_155341_);
                d0 += (double)direction.m_122429_() * 0.5;
                d2 += (double)direction.m_122431_() * 0.5;
            }
            p_155339_.m_6263_((Player)null, d0, d1, d2, p_155342_, SoundSource.BLOCKS, 0.5f, p_155339_.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
    }

    private IItemHandlerModifiable createHandler() {
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof GolemChestBlock)) {
            return new InvWrapper((Container)this);
        }
        Container inv = GolemChestBlock.m_51511_((ChestBlock)((GolemChestBlock)state.m_60734_()), (BlockState)state, (Level)this.m_58904_(), (BlockPos)this.m_58899_(), (boolean)true);
        return new InvWrapper((Container)(inv == null ? this : inv));
    }

    public void setUnlocked(boolean tf) {
        ChestType chesttype = (ChestType)this.m_58900_().m_61143_((Property)ChestBlock.f_51479_);
        this.unlocked = tf;
        if (chesttype != ChestType.SINGLE) {
            Direction direction = ChestBlock.m_51584_((BlockState)this.m_58900_());
            GolemChestBlockEntity chestEntity = null;
            try {
                chestEntity = (GolemChestBlockEntity)this.f_58857_.m_7702_(this.m_58899_().m_142300_(direction));
            }
            catch (Exception e) {
                BrassAmberBattleTowers.LOGGER.info((Object)e);
            }
            if (chestEntity != null) {
                chestEntity.unlocked = tf;
            }
        }
    }

    public boolean m_7525_(Player player) {
        return this.canUnlock(player, this.m_5446_());
    }

    public boolean canUnlock(Player player, Component component) {
        if (!this.unlocked && !player.m_5833_()) {
            player.m_5661_((Component)new TranslatableComponent("container.isLocked", new Object[]{component}), true);
            player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    @NotNull
    public BlockPos m_58899_() {
        return this.f_58858_;
    }

    public float m_6683_(float p_59604_) {
        return 0.0f;
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public void m_6520_(@NotNull NonNullList<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            this.items.set(i, (Object)((ItemStack)items.get(i)));
        }
    }
}

