/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.block.block;

import com.BrassAmber.ba_bt.block.blockentity.GolemChestBlockEntity;
import com.BrassAmber.ba_bt.util.BTUtil;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class GolemChestBlock
extends ChestBlock {
    private final BTChestType chestType;
    private final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final ChestBlockEntity chestBlockEntity1, final ChestBlockEntity chestBlockEntity2) {
            CompoundContainer iinventory = new CompoundContainer((Container)chestBlockEntity1, (Container)chestBlockEntity2);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$iinventory;
                {
                    this.val$iinventory = container;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player playerIn) {
                    if (chestBlockEntity1.m_7525_(playerIn) && chestBlockEntity2.m_7525_(playerIn)) {
                        chestBlockEntity1.m_59640_(playerInventory.f_35978_);
                        chestBlockEntity2.m_59640_(playerInventory.f_35978_);
                        return ChestMenu.m_39246_((int)containerId, (Inventory)playerInventory, (Container)this.val$iinventory);
                    }
                    return null;
                }

                public Component m_5446_() {
                    if (chestBlockEntity1.m_8077_()) {
                        return chestBlockEntity1.m_5446_();
                    }
                    return chestBlockEntity2.m_8077_() ? chestBlockEntity2.m_5446_() : new TranslatableComponent("container.ba_bt." + GolemChestBlock.this.getChestType().getName() + "_chest_double");
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(ChestBlockEntity chestBlockEntity) {
            return Optional.of(chestBlockEntity);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public GolemChestBlock(BTChestType chestType, Supplier<BlockEntityType<? extends ChestBlockEntity>> chestSupplier, BlockBehaviour.Properties properties) {
        super(properties, chestSupplier);
        this.chestType = chestType;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return BTUtil.getChestEntity((Block)this).m_155264_(blockPos, blockState);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public BTChestType getChestType() {
        return this.chestType;
    }

    public void m_6402_(Level world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(world, blockPos, blockState, livingEntity, itemStack);
        try {
            Player player = (Player)livingEntity;
            if (!player.m_7500_()) {
                GolemChestBlockEntity chestTileEntity = (GolemChestBlockEntity)world.m_7702_(blockPos);
                chestTileEntity.setUnlocked(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        GolemChestBlockEntity chestTileEntity = (GolemChestBlockEntity)world.m_7702_(pos);
        if (chestTileEntity.isUnlocked()) {
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        if (player != null && player.m_7500_()) {
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        return false;
    }

    public static enum BTChestType implements StringRepresentable
    {
        GOLEM("golem"),
        TOWER("tower");

        private String typeName;
        private static final BTChestType[] ALL_CHEST_TYPES;

        private BTChestType(String typeName) {
            this.typeName = typeName;
        }

        public String getName() {
            return this.typeName;
        }

        public static BTChestType getRandomChestType(Random rand) {
            return (BTChestType)((Object)Util.m_137545_((Object[])ALL_CHEST_TYPES, (Random)rand));
        }

        public String m_7912_() {
            return this.typeName;
        }

        static {
            ALL_CHEST_TYPES = BTChestType.values();
        }
    }
}

