/*
 * Decompiled with CFR 0.152.
 */
package snownee.passablefoliage;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="passablefoliage", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class PassableFoliageCommonConfig {
    public static float fallDamageReduction = 0.5f;
    public static int fallDamageThreshold = 20;
    public static float speedReductionHorizontal = 0.9f;
    public static float speedReductionVertical = 0.9f;
    public static boolean modifyPathFinding = true;
    public static boolean playerOnly = false;
    public static boolean soundsPlayerOnly = false;
    public static float soundVolume = 1.0f;
    private static ForgeConfigSpec.DoubleValue fallDamageReductionVal;
    private static ForgeConfigSpec.IntValue fallDamageThresholdVal;
    private static ForgeConfigSpec.DoubleValue speedReductionHorizontalVal;
    private static ForgeConfigSpec.DoubleValue speedReductionVerticalVal;
    private static ForgeConfigSpec.BooleanValue modifyPathFindingVal;
    private static ForgeConfigSpec.BooleanValue playerOnlyVal;
    private static ForgeConfigSpec.BooleanValue soundsPlayerOnlyVal;
    private static ForgeConfigSpec.DoubleValue soundVolumeVal;

    private PassableFoliageCommonConfig(ForgeConfigSpec.Builder builder) {
        fallDamageReductionVal = builder.comment(new String[]{"The percentage of normal damage taken when taking damage from falling into leaves.", "The damage will be reduced by a further 10% with the Jump Boost potion effect."}).defineInRange("fallDamageReduction", (double)fallDamageReduction, 0.0, 1.0);
        fallDamageThresholdVal = builder.comment("When falling into leaves, the (block) distance a player or mob has to fall before taking damage.").defineInRange("fallDamageThreshold", fallDamageThreshold, 5, 255);
        speedReductionHorizontalVal = builder.comment("The reduced horizontal speed when passing through leaves. (% of normal)").defineInRange("speedReductionHorizontal", (double)speedReductionHorizontal, 0.0, 1.0);
        speedReductionVerticalVal = builder.comment("The reduced vertical speed when passing through leaves. (% of normal)").defineInRange("speedReductionVertical", (double)speedReductionVertical, 0.0, 1.0);
        modifyPathFindingVal = builder.comment("Should entities recognize leaves as air").define("modifyPathFinding", modifyPathFinding);
        playerOnlyVal = builder.comment("Leaves only passable for players").define("playerOnly", playerOnly);
        builder.push("sounds");
        soundsPlayerOnlyVal = builder.comment("Only players can make noises").define("playerOnly", soundsPlayerOnly);
        soundVolumeVal = builder.defineInRange("volume", (double)soundVolume, 0.0, 10.0);
    }

    public static void refresh() {
        fallDamageReduction = ((Double)fallDamageReductionVal.get()).floatValue();
        fallDamageThreshold = (Integer)fallDamageThresholdVal.get();
        speedReductionHorizontal = ((Double)speedReductionHorizontalVal.get()).floatValue();
        speedReductionVertical = ((Double)speedReductionVerticalVal.get()).floatValue();
        modifyPathFinding = (Boolean)modifyPathFindingVal.get();
        playerOnly = (Boolean)playerOnlyVal.get();
        soundsPlayerOnly = (Boolean)soundsPlayerOnlyVal.get();
        soundVolume = ((Double)soundVolumeVal.get()).floatValue();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading event) {
        ((CommentedFileConfig)event.getConfig().getConfigData()).load();
        PassableFoliageCommonConfig.refresh();
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        PassableFoliageCommonConfig.refresh();
    }

    static {
        ForgeConfigSpec spec = (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(PassableFoliageCommonConfig::new).getRight();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec);
    }
}

