/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.mixin.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftFeatureConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class LayeredIntersection5
extends BetterMineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 10;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 9;
    private static final int LOCAL_Z_END = 4;

    public LayeredIntersection5(CompoundTag compoundTag) {
        super(BetterMineshaftStructurePieceType.LAYERED_INTERSECTION_5, compoundTag);
    }

    public LayeredIntersection5(int pieceChainLen, Random random, BoundingBox blockBox, Direction direction, BetterMineshaftFeatureConfiguration config) {
        super(BetterMineshaftStructurePieceType.LAYERED_INTERSECTION_5, pieceChainLen, config, blockBox);
        this.m_73519_(direction);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
    }

    public static BoundingBox determineBoxPosition(StructurePieceAccessor structurePieceAccessor, Random random, int x, int y, int z, Direction direction) {
        BoundingBox blockBox = new BoundingBox(x, y, z, x, y + 10 - 1, z);
        switch (direction) {
            default: {
                ((BoundingBoxAccessor)blockBox).setMaxX(x + 4);
                ((BoundingBoxAccessor)blockBox).setMinZ(z - 4);
                break;
            }
            case SOUTH: {
                ((BoundingBoxAccessor)blockBox).setMinX(x - 4);
                ((BoundingBoxAccessor)blockBox).setMaxZ(z + 4);
                break;
            }
            case WEST: {
                ((BoundingBoxAccessor)blockBox).setMinX(x - 4);
                ((BoundingBoxAccessor)blockBox).setMinZ(z - 4);
                break;
            }
            case EAST: {
                ((BoundingBoxAccessor)blockBox).setMaxX(x + 4);
                ((BoundingBoxAccessor)blockBox).setMaxZ(z + 4);
            }
        }
        StructurePiece intersectingPiece = structurePieceAccessor.m_141921_(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
        Direction direction = this.m_73549_();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), Direction.EAST, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_(), Direction.WEST, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + 5, this.f_73383_.m_162398_(), Direction.EAST, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + 5, this.f_73383_.m_162401_(), Direction.WEST, this.f_73384_);
                break;
            }
            case WEST: 
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_(), this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, Direction.SOUTH, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, Direction.NORTH, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_(), this.f_73383_.m_162396_() + 5, this.f_73383_.m_162401_() + 1, Direction.SOUTH, this.f_73384_);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() + 5, this.f_73383_.m_162398_() - 1, Direction.NORTH, this.f_73384_);
            }
        }
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        this.chanceReplaceNonAir(world, box, random, this.config.replacementRate, 0, 1, 0, 4, 9, 4, this.config.blockStateRandomizers.mainRandomizer);
        this.chanceReplaceNonAir(world, box, random, this.config.replacementRate, 0, 0, 0, 4, 0, 4, this.config.blockStateRandomizers.floorRandomizer);
        this.fill(world, box, 0, 1, 0, 4, 8, 3, AIR);
        this.fill(world, box, 0, 5, 4, 4, 8, 4, AIR);
        this.replaceAirOrChains(world, box, 0, 0, 0, 4, 0, 3, this.config.blockStates.mainBlockState);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.NORTH_SOUTH), 2, 1, 0, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.NORTH_SOUTH), 2, 1, 1, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.EAST_WEST), 0, 1, 2, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.EAST_WEST), 1, 1, 2, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.EAST_WEST), 3, 1, 2, box);
        this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.EAST_WEST), 4, 1, 2, box);
        this.fill(world, box, 0, 5, 0, 4, 5, 4, this.config.blockStates.mainBlockState);
        this.chanceReplaceNonAir(world, box, random, 0.5f, 0, 5, 0, 4, 5, 4, this.config.blockStateRandomizers.mainRandomizer);
        this.fill(world, box, 1, 5, 1, 3, 5, 3, AIR);
        this.fill(world, box, random, 1, 1, 1, 1, 8, 1, this.config.blockStateRandomizers.legRandomizer);
        this.fill(world, box, random, 3, 1, 1, 3, 8, 1, this.config.blockStateRandomizers.legRandomizer);
        this.fill(world, box, random, 1, 1, 3, 1, 8, 3, this.config.blockStateRandomizers.legRandomizer);
        this.fill(world, box, random, 3, 1, 3, 3, 8, 3, this.config.blockStateRandomizers.legRandomizer);
        BlockState LADDER = (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)Direction.SOUTH);
        this.fill(world, box, 2, 1, 3, 2, 5, 3, LADDER);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 4, 8, 4);
        this.addVines(world, box, random, this.config.decorationChances.vineChance, 1, 0, 1, 3, 9, 3);
        this.generatePillarsOrChains(world, box, random);
    }

    private void generatePillarsOrChains(WorldGenLevel world, BoundingBox boundingBox, Random random) {
        this.generatePillarDownOrChainUp(world, random, boundingBox, 1, 1, 0, 8, this.config.blockStates.smallLegBlockState);
        this.generatePillarDownOrChainUp(world, random, boundingBox, 3, 1, 0, 8, this.config.blockStates.smallLegBlockState);
        this.generatePillarDownOrChainUp(world, random, boundingBox, 1, 3, 0, 8, this.config.blockStates.smallLegBlockState);
        this.generatePillarDownOrChainUp(world, random, boundingBox, 3, 3, 0, 8, this.config.blockStates.smallLegBlockState);
    }
}

