/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshaftsCommon;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftFeatureConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.VerticalEntrance;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class BetterMineshaftStructureFeature
extends StructureFeature<BetterMineshaftFeatureConfiguration> {
    public BetterMineshaftStructureFeature() {
        super(BetterMineshaftFeatureConfiguration.CODEC, context -> {
            if (!BetterMineshaftStructureFeature.checkLocation((PieceGeneratorSupplier.Context<BetterMineshaftFeatureConfiguration>)context)) {
                return Optional.empty();
            }
            return Optional.of(BetterMineshaftStructureFeature::generatePieces);
        });
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<BetterMineshaftFeatureConfiguration> context) {
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        return worldgenRandom.nextDouble() < BetterMineshaftsCommon.CONFIG.mineshaftSpawnRate && context.f_197358_().test(context.f_197352_().m_203495_(QuartPos.m_175400_((int)context.f_197355_().m_151390_()), QuartPos.m_175400_((int)50), QuartPos.m_175400_((int)context.f_197355_().m_151393_())));
    }

    private static void generatePieces(StructurePiecesBuilder structurePiecesBuilder, PieceGenerator.Context<BetterMineshaftFeatureConfiguration> context) {
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        rand.m_190068_(context.f_192709_(), context.f_192705_().f_45578_, context.f_192705_().f_45579_);
        Direction direction = Direction.Plane.HORIZONTAL.m_122560_((Random)rand);
        int y = context.f_192708_().nextInt(BetterMineshaftsCommon.CONFIG.maxY - BetterMineshaftsCommon.CONFIG.minY + 1) + BetterMineshaftsCommon.CONFIG.minY;
        BlockPos.MutableBlockPos startingPos = new BlockPos.MutableBlockPos(context.f_192705_().m_151382_(3), y, context.f_192705_().m_151391_(3));
        VerticalEntrance entryPoint = new VerticalEntrance(-1, startingPos, direction, (BetterMineshaftFeatureConfiguration)context.f_197328_(), context.f_192707_().m_151558_());
        structurePiecesBuilder.m_142679_((StructurePiece)entryPoint);
        ((BetterMineshaftPiece)entryPoint).m_142537_(entryPoint, (StructurePieceAccessor)structurePiecesBuilder, (Random)context.f_192708_());
    }

    public static enum LegVariant implements StringRepresentable
    {
        EDGE("edge"),
        INNER("inner");

        public static final Codec<LegVariant> CODEC;
        private static final Map<String, LegVariant> BY_NAME;
        private final String name;

        private LegVariant(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static LegVariant byName(String name) {
            return BY_NAME.get(name);
        }

        public static LegVariant byId(int id) {
            return id >= 0 && id < LegVariant.values().length ? LegVariant.values()[id] : EDGE;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_14350_(LegVariant::values, LegVariant::byName);
            BY_NAME = Arrays.stream(LegVariant.values()).collect(Collectors.toMap(LegVariant::getName, variant -> variant));
        }
    }
}

