/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.core.integration.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Triple;
import xyz.apex.forge.commonality.tags.ItemTags;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.client.screen.FurnitureStationMenuScreen;
import xyz.apex.forge.fantasyfurniture.core.FurnitureStation;
import xyz.apex.forge.fantasyfurniture.core.registrate.DataGenerators;

public final class FurnitureStationRecipes {
    public static final RecipeType<FurnitureStationRecipes> RECIPE_TYPE = RecipeType.create((String)"fantasyfurniture", (String)"furniture_station", FurnitureStationRecipes.class);
    private final List<ItemStack> outputs;
    private final List<Ingredient> inputs;
    private final IDrawable furnitureSlotRenderer;
    private final IDrawable vanillaSlotRenderer;

    FurnitureStationRecipes(Collection<ItemStack> outputs, IJeiHelpers jei) {
        this.outputs = ImmutableList.copyOf(outputs);
        IGuiHelper gui = jei.getGuiHelper();
        this.furnitureSlotRenderer = gui.createDrawable(FurnitureStationMenuScreen.TEXTURE, 176, 18, 18, 18);
        this.vanillaSlotRenderer = gui.getSlotDrawable();
        this.inputs = Arrays.asList(Ingredient.m_204132_(FurnitureStation.CLAY), Ingredient.m_204132_((TagKey)ItemTags.Vanilla.PLANKS), Ingredient.m_204132_((TagKey)ItemTags.Vanilla.STONE_CRAFTING_MATERIALS));
    }

    void setRecipe(IRecipeLayoutBuilder builder) {
        int slotCounterStart;
        builder.moveRecipeTransferButton(110, 68);
        int xSize = this.vanillaSlotRenderer.getWidth() + 2;
        int xSpacing = xSize + 1;
        int x = 0;
        for (int i = 0; i < this.inputs.size(); ++i) {
            Ingredient input = this.inputs.get(i);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x + 1, 66).addIngredients(input)).setBackground(this.vanillaSlotRenderer, -1, -1);
            x += xSpacing;
        }
        int itemsPerRow = 6;
        int itemsPerCol = 4;
        xSize = this.furnitureSlotRenderer.getWidth() + 2;
        int ySize = this.furnitureSlotRenderer.getHeight() + 2;
        xSpacing = xSize + 1;
        int ySpacing = ySize + 1;
        int xStart = 0;
        int yStart = 178 - ySpacing * itemsPerCol;
        x = xStart;
        int y = yStart;
        int slotCounter = slotCounterStart = 3;
        HashMap slotMap = Maps.newHashMap();
        for (ItemStack stack : this.outputs) {
            int itemX = x + 1;
            int itemY = y + 1;
            Triple slotData2 = slotMap.computeIfAbsent(slotCounter, $ -> Triple.of((Object)itemX, (Object)itemY, (Object)Lists.newArrayList()));
            ((List)slotData2.getRight()).add(stack);
            ++slotCounter;
            if ((x += xSpacing) < xStart + xSpacing * itemsPerRow) continue;
            x = xStart;
            if ((y += ySpacing) < yStart + ySpacing * itemsPerCol) continue;
            slotCounter = slotCounterStart;
            y = yStart;
        }
        slotMap.forEach((slot, slotData) -> ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, ((Integer)slotData.getLeft()).intValue(), ((Integer)slotData.getMiddle()).intValue()).addIngredients(Ingredient.m_43921_(((List)slotData.getRight()).stream()))).setBackground(this.furnitureSlotRenderer, -1, -1));
    }

    void draw(PoseStack pose, IDrawable background) {
        this.renderBlock(pose, background);
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92763_(pose, (Component)new TranslatableComponent(DataGenerators.TXT_JEI_INGREDIENTS_KEY), 0.0f, 52.0f, -1);
        font.m_92763_(pose, (Component)new TranslatableComponent(DataGenerators.TXT_JEI_RESULTS_KEY), 0.0f, 84.0f, -1);
    }

    private void renderBlock(PoseStack pose, IDrawable background) {
        Minecraft mc = Minecraft.m_91087_();
        BlockState blockState = AllBlocks.FURNITURE_STATION.defaultBlockState();
        BakedModel model = mc.m_91289_().m_110910_(blockState);
        float frameTime = mc.m_91296_();
        float blockBobOffset = 0.0f;
        float f1 = Mth.m_14031_((float)(((float)mc.f_91074_.f_19797_ + frameTime) / 5.0f + blockBobOffset)) * 0.5f + 0.5f;
        float f2 = model.m_7442_().m_111808_((ItemTransforms.TransformType)ItemTransforms.TransformType.GROUND).f_111757_.m_122260_();
        float blockYOffset = f1 + 0.25f * f2;
        float blockRotation = ((float)mc.f_91074_.f_19797_ + frameTime) / 1.25f + blockBobOffset;
        int width = background.getWidth();
        int height = background.getHeight();
        double centerX = (double)width / 2.0;
        double centerY = (double)height / 2.0 - 64.0;
        double y = centerY - 4.0 + (double)blockYOffset;
        pose.m_85836_();
        pose.m_85837_(centerX, y, 10.0);
        pose.m_85841_(-32.0f, -32.0f, -32.0f);
        pose.m_85837_(-0.5, -0.5, 0.0);
        pose.m_85845_(Vector3f.f_122223_.m_122240_(-25.0f));
        pose.m_85837_(0.5, 0.0, -0.5);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(blockRotation));
        pose.m_85837_(-0.5, 0.0, 0.5);
        pose.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85837_(0.0, 0.0, -1.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        mc.m_91289_().renderSingleBlock(blockState, pose, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
        buffer.m_109911_();
        pose.m_85849_();
        pose.m_85849_();
    }
}

