/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.menu;

import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.container.BaseMenu;
import xyz.apex.forge.fantasyfurniture.AllBlockEntities;
import xyz.apex.forge.fantasyfurniture.common.block.entity.OvenBlockEntity;

public final class OvenMenu
extends BaseMenu {
    public static final int SLOT_COUNT = 3;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int DATA_SLOT_COUNT = 4;
    public static final int DATA_SLOT_BURN_TIME = 0;
    public static final int DATA_SLOT_TOTAL_BURN_TIME = 1;
    public static final int DATA_SLOT_SMELT_TIME = 2;
    public static final int DATA_SLOT_TOTAL_SMELT_TIME = 3;
    private final Player player;
    private final IItemHandler itemHandler;
    private final OvenBlockEntity blockEntity;
    private final Slot inputSlot;
    private final Slot outputSlot;
    private final Slot fuelSlot;
    private DataSlot burnTime;
    private DataSlot totalBurnTime;
    private DataSlot smeltTime;
    private DataSlot totalSmeltTime;

    public OvenMenu(@Nullable MenuType<? extends OvenMenu> menuType, int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        super(menuType, windowId, playerInventory, buffer);
        this.player = playerInventory.f_35978_;
        this.itemHandler = Objects.requireNonNull(this.getItemHandler());
        this.inputSlot = this.m_38897_((Slot)new InputSlot());
        this.outputSlot = this.m_38897_((Slot)new OutputSlot());
        this.fuelSlot = this.m_38897_((Slot)new FuelSlot());
        OvenMenu.bindPlayerInventory((BaseMenu)this, (int)8, (int)84);
        this.blockEntity = (OvenBlockEntity)((Object)AllBlockEntities.OVEN_BLOCK_ENTITY.get((BlockGetter)this.player.f_19853_, this.pos).orElseThrow());
        this.burnTime = this.m_38895_(DataSlot.m_39403_((ContainerData)this.blockEntity, (int)0));
        this.totalBurnTime = this.m_38895_(DataSlot.m_39403_((ContainerData)this.blockEntity, (int)1));
        this.smeltTime = this.m_38895_(DataSlot.m_39403_((ContainerData)this.blockEntity, (int)2));
        this.totalSmeltTime = this.m_38895_(DataSlot.m_39403_((ContainerData)this.blockEntity, (int)3));
    }

    public int getSmeltProgress() {
        int totalSmeltTime = this.totalSmeltTime.m_6501_();
        if (totalSmeltTime <= 0) {
            return -1;
        }
        int smeltTime = this.smeltTime.m_6501_();
        return smeltTime * 24 / totalSmeltTime;
    }

    public int getBurnProgress() {
        int burnTime = this.burnTime.m_6501_();
        if (burnTime <= 0) {
            return -1;
        }
        int totalBurnTime = this.totalBurnTime.m_6501_();
        if (totalBurnTime == 0) {
            totalBurnTime = 200;
        }
        return burnTime * 100 / totalBurnTime;
    }

    @Nullable
    public IItemHandler getItemHandler() {
        BlockEntity blockEntity = Objects.requireNonNull(this.player.f_19853_.m_7702_(this.pos));
        return OvenMenu.getItemHandlerFromBlockEntity((BlockEntity)blockEntity).resolve().orElse(null);
    }

    protected void onInventoryChanges() {
        super.onInventoryChanges();
        this.setBlockEntityChanged();
    }

    public final class InputSlot
    extends SlotItemHandler {
        public InputSlot() {
            super(OvenMenu.this.itemHandler, 0, 56, 17);
        }
    }

    public final class OutputSlot
    extends SlotItemHandler {
        private int removeCount;

        public OutputSlot() {
            super(OvenMenu.this.itemHandler, 2, 116, 35);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }

        @NotNull
        public ItemStack m_6201_(int amount) {
            if (this.m_6657_()) {
                this.removeCount += Math.min(amount, this.m_7993_().m_41613_());
            }
            return super.m_6201_(amount);
        }

        public void m_142406_(Player player, ItemStack stack) {
            this.m_5845_(stack);
            super.m_142406_(player, stack);
        }

        protected void m_7169_(ItemStack stack, int amount) {
            this.removeCount += amount;
            super.m_7169_(stack, amount);
        }

        protected void m_5845_(ItemStack stack) {
            stack.m_41678_(OvenMenu.this.player.f_19853_, OvenMenu.this.player, this.removeCount);
            Player player = OvenMenu.this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                OvenMenu.this.blockEntity.awardRecipesAndExperience(serverPlayer.m_183503_(), serverPlayer, Vec3.m_82512_((Vec3i)OvenMenu.this.pos));
            }
            this.removeCount = 0;
            ForgeEventFactory.firePlayerSmeltedEvent((Player)OvenMenu.this.player, (ItemStack)stack);
        }
    }

    public final class FuelSlot
    extends SlotItemHandler {
        public FuelSlot() {
            super(OvenMenu.this.itemHandler, 1, 56, 53);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return OvenMenu.this.blockEntity.canBurn(stack);
        }
    }
}

