/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.decorations;

import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.AllParticleTypes;

public final class CandelabraBlock
extends BaseBlock {
    public static final VoxelShape SHAPE = VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0), Block.m_49796_((double)3.0, (double)5.0, (double)7.0, (double)13.0, (double)7.0, (double)9.0), Block.m_49796_((double)11.0, (double)7.0, (double)7.0, (double)13.0, (double)13.0, (double)9.0), Block.m_49796_((double)3.0, (double)7.0, (double)7.0, (double)5.0, (double)13.0, (double)9.0), Block.m_49796_((double)2.5, (double)9.0, (double)6.5, (double)5.5, (double)10.0, (double)9.5), Block.m_49796_((double)6.5, (double)10.0, (double)6.5, (double)9.5, (double)11.0, (double)9.5), Block.m_49796_((double)10.5, (double)9.0, (double)6.5, (double)13.5, (double)10.0, (double)9.5)});
    public static final VoxelShape NECROLORD_SHAPE = VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0), Block.m_49796_((double)1.25, (double)5.0, (double)6.5, (double)14.75, (double)12.0, (double)9.5), Block.m_49796_((double)12.25, (double)12.0, (double)7.0, (double)14.25, (double)15.0, (double)9.0), Block.m_49796_((double)1.75, (double)12.0, (double)7.0, (double)3.75, (double)15.0, (double)9.0), Block.m_49796_((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
    public static final VoxelShaper SHAPER = VoxelShaper.forHorizontal((VoxelShape)SHAPE, (Direction)Direction.NORTH);
    public static final VoxelShaper NECROLORD_SHAPER = VoxelShaper.forHorizontal((VoxelShape)NECROLORD_SHAPE, (Direction)Direction.NORTH);

    public CandelabraBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)FACING_4_WAY);
        consumer.accept((Property<?>)WATERLOGGED);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        Direction facing = CandelabraBlock.getFacing((BlockState)blockState);
        VoxelShaper shaper = AllBlocks.NECROLORD_CANDELABRA.is((Block)this) ? NECROLORD_SHAPER : SHAPER;
        return shaper.get(facing);
    }

    public void m_7100_(BlockState blockState, Level level, BlockPos pos, Random rng) {
        if (!CandelabraBlock.isWaterLogged((BlockState)blockState)) {
            this.spawnLightParticles(blockState, level, pos, rng);
        }
    }

    private void spawnLightParticles(BlockState blockState, Level level, BlockPos pos, Random rng) {
        if (AllBlocks.ROYAL_CANDELABRA.isIn(blockState)) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5 + 0.45 + 0.075;
            double z = (double)pos.m_123343_() + 0.5;
            Direction facing = CandelabraBlock.getFacing((BlockState)blockState).m_122427_();
            int stepX = facing.m_122429_();
            int stepZ = facing.m_122431_();
            this.onLightParticle(level, pos, blockState, x, y, z, rng);
            this.onLightParticle(level, pos, blockState, x + (double)stepX * 0.25, y - 0.05, z + (double)stepZ * 0.25, rng);
            this.onLightParticle(level, pos, blockState, x - (double)stepX * 0.25, y - 0.05, z - (double)stepZ * 0.25, rng);
        } else if (AllBlocks.NECROLORD_CANDELABRA.isIn(blockState)) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5 + 0.6;
            double z = (double)pos.m_123343_() + 0.5;
            Direction facing = CandelabraBlock.getFacing((BlockState)blockState).m_122427_();
            int stepX = facing.m_122429_();
            int stepZ = facing.m_122431_();
            this.onLightParticle(level, pos, blockState, x, y, z, rng);
            this.onLightParticle(level, pos, blockState, x + (double)stepX * 0.3, y - 0.05, z + (double)stepZ * 0.3, rng);
            this.onLightParticle(level, pos, blockState, x - (double)stepX * 0.3, y - 0.05, z - (double)stepZ * 0.3, rng);
        }
    }

    private void onLightParticle(Level level, BlockPos pos, BlockState blockState, double pX, double pY, double pZ, Random rng) {
        SimpleParticleType flame = ParticleTypes.f_175834_;
        if (AllBlocks.NECROLORD_CANDELABRA.isIn(blockState)) {
            flame = (SimpleParticleType)AllParticleTypes.SMALL_NECROLORD_FLAME.get();
        }
        level.m_7106_((ParticleOptions)flame, pX, pY, pZ, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pX, pY, pZ, 0.0, 0.0, 0.0);
    }
}

