/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public final class StatUtils {
    private StatUtils() {
    }

    public static ArrayList<StatUtilsGeneralStat> getGeneralStats(StatsCounter StatsCounter2, Predicate<StatUtilsStat> filter) {
        ArrayList result = Lists.newArrayList();
        Objects.requireNonNull(StatsCounter2, "StatsCounter must not be null.");
        ObjectArrayList statiList = new ObjectArrayList(Stats.f_12988_.iterator());
        statiList.sort(Comparator.comparing(stat -> TextUtils.translatable((String)StatUtils.getStatTranslationKey((Stat<ResourceLocation>)stat), (Object[])new Object[0]).getString()));
        ObjectListIterator statListIterator = statiList.iterator();
        while (statListIterator.hasNext()) {
            result.add(new StatUtilsGeneralStat(StatsCounter2, (Stat<ResourceLocation>)((Stat)statListIterator.next())));
        }
        if (filter != null) {
            result.removeIf(filter.negate());
        }
        return result;
    }

    public static LinkedHashMap<CreativeModeTab, ArrayList<StatUtilsItemStat>> getItemStats(StatsCounter StatsCounter2, Predicate<StatUtilsStat> filter) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.put(null, new ArrayList());
        for (Item itemReg : ForgeRegistries.ITEMS) {
            CreativeModeTab tab;
            StatUtilsItemStat itemStat = new StatUtilsItemStat(StatsCounter2, itemReg);
            if (filter != null && !filter.test(itemStat)) continue;
            Collection tabs = itemReg.getCreativeTabs();
            CreativeModeTab creativeModeTab = tab = tabs.size() > 0 ? (CreativeModeTab)tabs.iterator().next() : null;
            if (!result.containsKey(tab)) {
                result.put(tab, Lists.newArrayList());
            }
            ((ArrayList)result.get(tab)).add(itemStat);
        }
        if (((ArrayList)result.get(null)).size() == 0) {
            result.remove(null);
        }
        return result;
    }

    public static LinkedHashMap<String, ArrayList<StatUtilsMobStat>> getMobStats(StatsCounter StatsCounter2, Predicate<StatUtilsStat> filter) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        String mcModId = new ResourceLocation("air").m_135827_();
        result.put(mcModId, Lists.newArrayList());
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            if (entityType != EntityType.f_20532_ && !entityType.m_20654_()) continue;
            StatUtilsMobStat mobStat = new StatUtilsMobStat(StatsCounter2, entityType);
            if (filter != null && !filter.test(mobStat)) continue;
            String entityModId = EntityType.m_20613_((EntityType)entityType).m_135827_();
            if (!result.containsKey(entityModId)) {
                result.put(entityModId, Lists.newArrayList());
            }
            ArrayList resultList = (ArrayList)result.get(entityModId);
            resultList.add(mobStat);
        }
        if (((ArrayList)result.get(mcModId)).size() == 0) {
            result.remove(mcModId);
        }
        return result;
    }

    public static LinkedHashMap<String, ArrayList<StatUtilsItemStat>> getItemStatsByMods(StatsCounter StatsCounter2, Predicate<StatUtilsStat> filter) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        String mcModId = new ResourceLocation("air").m_135827_();
        result.put(mcModId, Lists.newArrayList());
        for (Item itemReg : ForgeRegistries.ITEMS) {
            StatUtilsItemStat itemStat = new StatUtilsItemStat(StatsCounter2, itemReg);
            if (filter != null && !filter.test(itemStat)) continue;
            String itemModId = ((ResourceKey)ForgeRegistries.ITEMS.getResourceKey((IForgeRegistryEntry)itemReg).get()).m_135782_().m_135827_();
            if (!result.containsKey(itemModId)) {
                result.put(itemModId, Lists.newArrayList());
            }
            ArrayList resultList = (ArrayList)result.get(itemModId);
            resultList.add(itemStat);
        }
        if (((ArrayList)result.get(mcModId)).size() == 0) {
            result.remove(mcModId);
        }
        return result;
    }

    public static String getStatTranslationKey(Stat<ResourceLocation> stat) {
        return "stat." + ((ResourceLocation)stat.m_12867_()).toString().replace(':', '.');
    }

    public static String getModName(String modId) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{modId})) {
            return "*";
        }
        Optional container = ModList.get().getModContainerById(modId);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getModInfo().getDisplayName();
        }
        return modId;
    }

    public static class StatUtilsGeneralStat
    extends StatUtilsStat {
        public final Stat<ResourceLocation> stat;
        public final int intValue;
        public final MutableComponent value;
        public final boolean isEmpty;

        public StatUtilsGeneralStat(StatsCounter statsCounter, Stat<ResourceLocation> generalStat) {
            super(Objects.requireNonNull(statsCounter, "StatsCounter must not be null."), TextUtils.fTranslatable((String)StatUtils.getStatTranslationKey(Objects.requireNonNull(generalStat, "generalStat must not be null.")), (Object[])new Object[0]));
            this.stat = generalStat;
            this.intValue = statsCounter.m_13015_(this.stat);
            this.value = TextUtils.literal((String)this.stat.m_12860_(this.intValue));
            this.isEmpty = this.intValue == 0;
        }

        @Override
        public boolean isEmpty() {
            return this.isEmpty;
        }
    }

    public static class StatUtilsItemStat
    extends StatUtilsStat {
        public final Item item;
        public final Block block;
        public final int sMined;
        public final int sCrafted;
        public final int sUsed;
        public final int sBroken;
        public final int sPickedUp;
        public final int sDropped;
        public final boolean isEmpty;

        public StatUtilsItemStat(StatsCounter statsCounter, Item item) {
            super(Objects.requireNonNull(statsCounter, "StatsCounter must not be null."), TextUtils.fTranslatable((String)Objects.requireNonNull(item, "item must not be null.").m_5524_(), (Object[])new Object[0]));
            this.item = item;
            this.block = Block.m_49814_((Item)item);
            this.sMined = this.block == null || this.block.m_49966_().m_60795_() ? 0 : statsCounter.m_13017_(Stats.f_12949_, (Object)this.block);
            this.sCrafted = statsCounter.m_13017_(Stats.f_12981_, (Object)item);
            this.sUsed = statsCounter.m_13017_(Stats.f_12982_, (Object)item);
            this.sBroken = statsCounter.m_13017_(Stats.f_12983_, (Object)item);
            this.sPickedUp = statsCounter.m_13017_(Stats.f_12984_, (Object)item);
            this.sDropped = statsCounter.m_13017_(Stats.f_12985_, (Object)item);
            this.isEmpty = this.sMined == 0 && this.sCrafted == 0 && this.sUsed == 0 && this.sBroken == 0 && this.sPickedUp == 0 && this.sDropped == 0;
        }

        @Override
        public boolean isEmpty() {
            return this.isEmpty;
        }
    }

    public static class StatUtilsMobStat
    extends StatUtilsStat {
        public final EntityType<?> entityType;
        public final int killed;
        public final int killedBy;
        public final boolean isEmpty;

        public StatUtilsMobStat(StatsCounter StatsCounter2, EntityType<?> entityType) {
            super(Objects.requireNonNull(StatsCounter2, "StatsCounter must not be null."), TextUtils.fTranslatable((String)Objects.requireNonNull(entityType, "entityType must not be null.").m_20675_(), (Object[])new Object[0]));
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            this.killed = StatsCounter2.m_13017_(Stats.f_12986_, entityType);
            this.killedBy = StatsCounter2.m_13017_(Stats.f_12987_, entityType);
            this.isEmpty = this.killed == 0 && this.killedBy == 0;
        }

        @Override
        public boolean isEmpty() {
            return this.isEmpty;
        }
    }

    public static abstract class StatUtilsStat {
        public final StatsCounter statsCounter;
        public final Component label;
        private final String sqLabel;

        public StatUtilsStat(StatsCounter StatsCounter2, Component label) {
            this.statsCounter = StatsCounter2;
            this.label = Objects.requireNonNull(label, "label must not be null.");
            this.sqLabel = this.label.getString().toLowerCase().replaceAll("\\s+", "");
        }

        public abstract boolean isEmpty();

        public final boolean matchesSearchQuery(String search) {
            search = search.toLowerCase().replaceAll("\\s+", "");
            return search.startsWith(this.sqLabel);
        }
    }
}

