/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui_hud.widget;

import io.github.thecsdev.betterstats.client.gui_hud.widget.BSHudStatWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.EntityType;

public class BSHudStatWidget_Entity
extends BSHudStatWidget {
    public final EntityType<?> entityType;
    protected BSHudStatWidget.LabelEntry lblStatEntry;
    protected boolean showKills = true;
    protected boolean showDeaths = true;

    public BSHudStatWidget_Entity(int x, int y, StatsCounter statHandler, EntityType<?> entityType) {
        super(x, y, statHandler);
        this.entityType = Objects.requireNonNull(entityType, "entityType must not be null.");
    }

    public void tick() {
        this.lblStatEntry.setText(this.createText());
    }

    @Override
    public void onInit() {
        this.addEntityEntry(this.entityType);
        this.lblStatEntry = new BSHudStatWidget.LabelEntry(null);
    }

    public Component createText() {
        int kills = this.statHandler.m_13015_(Stats.f_12986_.m_12902_(this.entityType));
        int deaths = this.statHandler.m_13015_(Stats.f_12987_.m_12902_(this.entityType));
        String txt_a = kills + " " + TextUtils.translatable((String)"betterstats.hud.entity.kills", (Object[])new Object[0]).getString();
        String txt_b = deaths + " " + TextUtils.translatable((String)"betterstats.hud.entity.deaths", (Object[])new Object[0]).getString();
        Object txt = "";
        if (this.showKills) {
            txt = (String)txt + txt_a;
        }
        if (this.showDeaths) {
            txt = (String)txt + (((String)txt).length() > 0 ? ", " : "") + txt_b;
        }
        return TextUtils.literal((String)txt);
    }

    @Override
    protected void onContextMenu(TContextMenuPanel contextMenu) {
        contextMenu.addButton((Component)TextUtils.translatable((String)"betterstats.hud.entity.kills", (Object[])new Object[0]), btn -> {
            this.showKills = !this.showKills;
            this.tick();
        });
        contextMenu.addButton((Component)TextUtils.translatable((String)"betterstats.hud.entity.deaths", (Object[])new Object[0]), btn -> {
            this.showDeaths = !this.showDeaths;
            this.tick();
        });
        super.onContextMenu(contextMenu);
    }
}

