/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui_hud.screen;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.client.gui_hud.screen.BshsAutoRequest;
import io.github.thecsdev.betterstats.client.gui_hud.widget.BSHudStatWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.client.registry.TCDCommonsClientRegistry;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.HashSet;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class BetterStatsHudScreen
extends TScreen {
    public static final ResourceLocation HUD_ID = new ResourceLocation(BetterStats.getModID(), "hud");
    protected Screen parent;
    protected TButtonWidget btn_done;
    public int flag_tickChildren = -1;
    public final HashSet<BSHudStatWidget> stat_widgets = Sets.newHashSet();

    @Nullable
    public static BetterStatsHudScreen getInstance() {
        Screen bshs = (Screen)TCDCommonsClientRegistry.InGameHud_Screens.get(HUD_ID);
        if (bshs instanceof BetterStatsHudScreen) {
            return (BetterStatsHudScreen)bshs;
        }
        return null;
    }

    public static BetterStatsHudScreen getOrCreateInstance(Screen parent) throws RuntimeException {
        BetterStatsHudScreen bshs = BetterStatsHudScreen.getInstance();
        if (bshs == null) {
            bshs = new BetterStatsHudScreen(null);
            TCDCommonsClientRegistry.InGameHud_Screens.put(HUD_ID, bshs);
        }
        bshs.parent = parent;
        return bshs;
    }

    public BetterStatsHudScreen(Screen parent) {
        super((Component)TextUtils.translatable((String)"betterstats.hud", (Object[])new Object[0]));
        this.parent = parent;
    }

    protected void onClosed() {
        this.getClient().m_91152_(this.parent);
        this.m_96624_();
        this.parent = null;
        if (this.findTChildOfType(BSHudStatWidget.class, false) == null) {
            TCDCommonsClientRegistry.InGameHud_Screens.remove(HUD_ID, (Object)this);
        }
    }

    public <T extends BSHudStatWidget> T addHudStatWidget(T widget) {
        if (widget == null || this.stat_widgets.contains(widget)) {
            return widget;
        }
        widget.setPosition(this.getTpeWidth() / 2 - widget.getTpeWidth() / 2, this.getTpeHeight() / 2 - 42, false);
        this.addTChild(widget, false);
        return widget;
    }

    public <T extends TElement> boolean addTChild(T child, boolean reposition) {
        if (super.addTChild(child, reposition)) {
            if (child instanceof BSHudStatWidget && !this.stat_widgets.contains(child)) {
                BSHudStatWidget bshsw = (BSHudStatWidget)child;
                this.stat_widgets.add(bshsw);
                bshsw.reCalculateAnchor();
            }
            return true;
        }
        return false;
    }

    public <T extends TElement> boolean removeTChild(T child, boolean reposition) {
        if (super.removeTChild(child, reposition)) {
            if (child instanceof BSHudStatWidget) {
                this.stat_widgets.remove((Object)((BSHudStatWidget)child));
            }
            return true;
        }
        return false;
    }

    protected void m_7856_() {
        this.btn_done = new TButtonWidget(this.getTpeWidth() / 2 - 50, this.getTpeHeight() / 2 - 10, 100, 20, (Component)TextUtils.translatable((String)"gui.done", (Object[])new Object[0]), btn -> this.close());
        this.addTChild((TElement)this.btn_done);
        MutableComponent txt_hint_a = TextUtils.translatable((String)"betterstats.hud.hint.add_widget", (Object[])new Object[0]);
        MutableComponent txt_hint_b = TextUtils.translatable((String)"betterstats.hud.hint.del_widget", (Object[])new Object[0]);
        MutableComponent txt_hint_c = TextUtils.translatable((String)"betterstats.hud.hint.esc_close", (Object[])new Object[0]);
        MutableComponent txt_hint = TextUtils.literal((String)("1. " + txt_hint_a.getString() + "\n2. " + txt_hint_b.getString() + "\n3. " + txt_hint_c.getString()));
        this.btn_done.setTooltip((Component)txt_hint);
        this.stat_widgets.remove(null);
        for (BSHudStatWidget entry : this.stat_widgets) {
            this.addTChild(entry, false);
            entry.rePositionToAnchor();
        }
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.flag_tickChildren > 0) {
            --this.flag_tickChildren;
        } else if (this.flag_tickChildren == 0) {
            this.tickChildren();
            this.flag_tickChildren = -1;
        }
        this.btn_done.setVisible(this.getClient().f_91080_ == this);
        BshsAutoRequest.tick();
    }

    public final void tickChildren() {
        this.forEachChild(child -> {
            child.tick();
            return false;
        }, true);
    }

    public void m_7333_(PoseStack matrices) {
        if (this.getClient().f_91080_ == this) {
            BetterStatsHudScreen.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)0x50000000);
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        if (this.getClient().f_91080_ != null && this.getClient().f_91080_ != this) {
            return;
        }
        super.m_6305_(matrices, mouseX, mouseY, deltaTime);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.getClient().f_91080_ != this) {
            return false;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        TElement hovered;
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if ((keyCode == 259 || keyCode == 261) && (hovered = this.getHoveredTChild()) instanceof BSHudStatWidget) {
            this.removeTChild(hovered);
            return true;
        }
        return false;
    }
}

