/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.panel.stats;

import io.github.thecsdev.betterstats.api.registry.BetterStatsRegistry;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TEntityRendererElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class BSStatPanel_Mobs
extends BSStatPanel {
    public BSStatPanel_Mobs(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public BSStatPanel_Mobs(TPanelElement parentToFill) {
        super(parentToFill);
    }

    @Override
    public Predicate<StatUtils.StatUtilsStat> getStatPredicate() {
        return stat -> {
            if (!(stat instanceof StatUtils.StatUtilsMobStat)) {
                return false;
            }
            Entity ent = TEntityRendererElement.getCachedEntityFromType(((StatUtils.StatUtilsMobStat)stat).entityType);
            return ent instanceof LivingEntity || !stat.isEmpty();
        };
    }

    @Override
    public void init(StatsCounter statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        LinkedHashMap<String, ArrayList<StatUtils.StatUtilsMobStat>> mobStats = StatUtils.getMobStats(statHandler, statFilter.and(this.getStatPredicate()));
        for (String mobGroup : mobStats.keySet()) {
            this.init_groupLabel((Component)TextUtils.literal((String)StatUtils.getModName(mobGroup)));
            this.init_mobStats(mobStats.get(mobGroup));
        }
        if (mobStats.size() == 0) {
            this.init_noResults();
        } else {
            this.init_totalStats(mobStats.values());
        }
    }

    protected void init_mobStats(ArrayList<StatUtils.StatUtilsMobStat> mobStats) {
        int nextX = this.getTpeX() + this.getScrollPadding();
        int nextY = this.getTpeY() + this.getScrollPadding();
        TElement lastChild = this.getLastTChild(false);
        if (lastChild != null) {
            nextY = lastChild.getTpeEndY() + 2;
        }
        int SIZE = 50;
        for (StatUtils.StatUtilsMobStat stat : mobStats) {
            this.addTChild(this.createStatWidget(stat, nextX, nextY, 50), false);
            if ((nextX += 52) + 50 <= this.getTpeEndX() - this.getScrollPadding()) continue;
            nextX = this.getTpeX() + this.getScrollPadding();
            nextY += 52;
        }
    }

    protected void init_totalStats(Collection<ArrayList<StatUtils.StatUtilsMobStat>> mobStats) {
        int kills = 0;
        int deaths = 0;
        for (ArrayList<StatUtils.StatUtilsMobStat> group : mobStats) {
            for (StatUtils.StatUtilsMobStat groupItem : group) {
                if (groupItem == null || groupItem.isEmpty()) continue;
                kills += groupItem.killed;
                deaths += groupItem.killedBy;
            }
        }
        StringBuilder glSb = new StringBuilder();
        glSb.append(new char[]{'\u2190', ' ', '\u2022', ' ', '\u2192'});
        TLabelElement groupLabel = this.init_groupLabel((Component)TextUtils.literal((String)glSb.toString()));
        groupLabel.setHorizontalAlignment(HorizontalAlignment.CENTER);
        int nextX = this.getTpeX() + this.getScrollPadding();
        int nextY = this.getTpeY() + this.getScrollPadding();
        TElement lastChild = this.getLastTChild(false);
        if (lastChild != null) {
            nextY = lastChild.getTpeEndY() + 2;
        }
        BSPanel panel = new BSPanel(nextX, nextY, this.getTpeWidth() - this.getScrollPadding() * 2, 20);
        panel.setScrollPadding(0);
        this.addTChild((TElement)panel, false);
        int leftX = 5;
        int leftW = panel.getTpeWidth() / 2 - 10;
        int rightX = panel.getTpeWidth() / 2 + 5;
        int rightW = panel.getTpeWidth() / 2 - 10;
        TLabelElement lbl_kills_a = new TLabelElement(leftX, 0, leftW, 20, (Component)TextUtils.translatable((String)"betterstats.hud.entity.kills", (Object[])new Object[0]));
        TLabelElement lbl_kills_b = new TLabelElement(leftX, 0, leftW, 20, (Component)TextUtils.literal((String)Integer.toString(kills)));
        lbl_kills_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        TLabelElement lbl_deaths_a = new TLabelElement(rightX, 0, rightW, 20, (Component)TextUtils.translatable((String)"betterstats.hud.entity.deaths", (Object[])new Object[0]));
        TLabelElement lbl_deaths_b = new TLabelElement(rightX, 0, rightW, 20, (Component)TextUtils.literal((String)Integer.toString(deaths)));
        lbl_deaths_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_kills_a, true);
        panel.addTChild((TElement)lbl_kills_b, true);
        panel.addTChild((TElement)lbl_deaths_a, true);
        panel.addTChild((TElement)lbl_deaths_b, true);
    }

    protected BSStatWidget_Mob createStatWidget(StatUtils.StatUtilsMobStat stat, int x, int y, int size) {
        return new BSStatWidget_Mob(stat, x, y, size);
    }

    protected class BSStatWidget_Mob
    extends BSStatPanel.BSStatWidget {
        public final StatUtils.StatUtilsMobStat stat;

        public BSStatWidget_Mob(StatUtils.StatUtilsMobStat stat, int x, int y, int size) {
            super(x, y, size, size);
            this.stat = Objects.requireNonNull(stat, "stat must not be null.");
            this.addTChild((TElement)new TEntityRendererElement(x, y, size, size, stat.entityType), false);
            this.updateTooltip();
        }

        @Override
        public void updateTooltip() {
            String entityName = this.stat.label.getString();
            String s0 = TextUtils.translatable((String)"stat_type.minecraft.killed.none", (Object[])new Object[]{entityName}).getString();
            String s1 = TextUtils.translatable((String)"stat_type.minecraft.killed_by.none", (Object[])new Object[]{entityName}).getString();
            if (this.stat.killed != 0) {
                s0 = TextUtils.translatable((String)"stat_type.minecraft.killed", (Object[])new Object[]{Integer.toString(this.stat.killed), entityName}).getString();
            }
            if (this.stat.killedBy != 0) {
                s1 = TextUtils.translatable((String)"stat_type.minecraft.killed_by", (Object[])new Object[]{entityName, Integer.toString(this.stat.killedBy)}).getString();
            }
            this.setTooltip((Component)TextUtils.literal((String)(s0 + "\n" + s1)));
        }

        @Override
        public boolean mousePressed(int mouseX, int mouseY, int button) {
            String url;
            if (button == 2 && (url = BetterStatsRegistry.getMobWikiURL(ForgeRegistries.ENTITIES.getKey(this.stat.entityType))) != null) {
                GuiUtils.showUrlPrompt((String)url, (boolean)false);
                return false;
            }
            return super.mousePressed(mouseX, mouseY, button);
        }
    }
}

