/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.panel.stats;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.betterstats.api.registry.BetterStatsRegistry;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel;
import io.github.thecsdev.betterstats.util.ItemStatEnum;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BSStatPanel_Items
extends BSStatPanel {
    public BSStatPanel_Items(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public BSStatPanel_Items(TPanelElement parentToFill) {
        super(parentToFill);
    }

    @Override
    public Predicate<StatUtils.StatUtilsStat> getStatPredicate() {
        return stat -> stat instanceof StatUtils.StatUtilsItemStat;
    }

    @Override
    public void init(StatsCounter statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        LinkedHashMap<CreativeModeTab, ArrayList<StatUtils.StatUtilsItemStat>> itemStats = StatUtils.getItemStats(statHandler, statFilter.and(this.getStatPredicate()));
        for (CreativeModeTab iGroup : itemStats.keySet()) {
            Component gLabel = iGroup != null ? iGroup.m_40786_() : null;
            this.init_groupLabel(gLabel);
            this.init_itemStats(itemStats.get(iGroup));
        }
        if (itemStats.size() == 0) {
            this.init_noResults();
        } else {
            this.init_totalStats(itemStats.values());
        }
    }

    protected void init_itemStats(ArrayList<StatUtils.StatUtilsItemStat> itemStats) {
        int nextX = this.getTpeX() + this.getScrollPadding();
        int nextY = this.getTpeY() + this.getScrollPadding();
        TElement lastChild = this.getLastTChild(false);
        if (lastChild != null) {
            nextY = lastChild.getTpeEndY() + 2;
        }
        for (StatUtils.StatUtilsItemStat stat : itemStats) {
            this.addTChild(this.createStatWidget(stat, nextX, nextY), false);
            if ((nextX += 22) + 21 <= this.getTpeEndX() - this.getScrollPadding()) continue;
            nextX = this.getTpeX() + this.getScrollPadding();
            nextY += 22;
        }
    }

    protected void init_totalStats(Collection<ArrayList<StatUtils.StatUtilsItemStat>> itemStats) {
        int tMined = 0;
        int tCrafted = 0;
        int tUsed = 0;
        int tBroken = 0;
        int tPickedUp = 0;
        int tDropped = 0;
        for (ArrayList<StatUtils.StatUtilsItemStat> group : itemStats) {
            for (StatUtils.StatUtilsItemStat groupMob : group) {
                if (groupMob == null || groupMob.isEmpty()) continue;
                tMined += groupMob.sMined;
                tCrafted += groupMob.sCrafted;
                tUsed += groupMob.sUsed;
                tBroken += groupMob.sBroken;
                tPickedUp += groupMob.sPickedUp;
                tDropped += groupMob.sDropped;
            }
        }
        StringBuilder glSb = new StringBuilder();
        glSb.append(new char[]{'\u2190', ' ', '\u2022', ' ', '\u2192'});
        TLabelElement groupLabel = this.init_groupLabel((Component)TextUtils.literal((String)glSb.toString()));
        groupLabel.setHorizontalAlignment(HorizontalAlignment.CENTER);
        int nextX = this.getTpeX() + this.getScrollPadding();
        int nextY = this.getTpeY() + this.getScrollPadding();
        TElement lastChild = this.getLastTChild(false);
        if (lastChild != null) {
            nextY = lastChild.getTpeEndY() + 2;
        }
        BSPanel panel = new BSPanel(nextX, nextY, this.getTpeWidth() - this.getScrollPadding() * 2, 60);
        panel.setScrollPadding(0);
        this.addTChild((TElement)panel, false);
        int leftX = 5;
        int leftW = panel.getTpeWidth() / 2 - 10;
        int rightX = panel.getTpeWidth() / 2 + 5;
        int rightW = panel.getTpeWidth() / 2 - 10;
        TLabelElement lbl_tMined_a = new TLabelElement(leftX, 0, leftW, 20, ItemStatEnum.MINED.getIText());
        TLabelElement lbl_tMined_b = new TLabelElement(leftX, 0, leftW, 20, (Component)TextUtils.literal((String)Integer.toString(tMined)));
        lbl_tMined_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tMined_a, true);
        panel.addTChild((TElement)lbl_tMined_b, true);
        TLabelElement lbl_tCrafted_a = new TLabelElement(rightX, 0, rightW, 20, ItemStatEnum.CRAFTED.getIText());
        TLabelElement lbl_tCrafted_b = new TLabelElement(rightX, 0, rightW, 20, (Component)TextUtils.literal((String)Integer.toString(tCrafted)));
        lbl_tCrafted_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tCrafted_a, true);
        panel.addTChild((TElement)lbl_tCrafted_b, true);
        TLabelElement lbl_tUsed_a = new TLabelElement(leftX, 20, leftW, 20, ItemStatEnum.USED.getIText());
        TLabelElement lbl_tUsed_b = new TLabelElement(leftX, 20, leftW, 20, (Component)TextUtils.literal((String)Integer.toString(tUsed)));
        lbl_tUsed_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tUsed_a, true);
        panel.addTChild((TElement)lbl_tUsed_b, true);
        TLabelElement lbl_tBroken_a = new TLabelElement(rightX, 20, rightW, 20, ItemStatEnum.BROKEN.getIText());
        TLabelElement lbl_tBroken_b = new TLabelElement(rightX, 20, rightW, 20, (Component)TextUtils.literal((String)Integer.toString(tBroken)));
        lbl_tBroken_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tBroken_a, true);
        panel.addTChild((TElement)lbl_tBroken_b, true);
        TLabelElement lbl_tPickedUp_a = new TLabelElement(leftX, 40, leftW, 20, ItemStatEnum.PICKED_UP.getIText());
        TLabelElement lbl_tPickedUp_b = new TLabelElement(leftX, 40, leftW, 20, (Component)TextUtils.literal((String)Integer.toString(tPickedUp)));
        lbl_tPickedUp_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tPickedUp_a, true);
        panel.addTChild((TElement)lbl_tPickedUp_b, true);
        TLabelElement lbl_tDropped_a = new TLabelElement(rightX, 40, rightW, 20, ItemStatEnum.DROPPED.getIText());
        TLabelElement lbl_tDropped_b = new TLabelElement(rightX, 40, rightW, 20, (Component)TextUtils.literal((String)Integer.toString(tDropped)));
        lbl_tDropped_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tDropped_a, true);
        panel.addTChild((TElement)lbl_tDropped_b, true);
    }

    protected BSStatWidget_Item createStatWidget(StatUtils.StatUtilsItemStat stat, int x, int y) {
        return new BSStatWidget_Item(stat, x, y);
    }

    protected class BSStatWidget_Item
    extends BSStatPanel.BSStatWidget {
        public static final int SIZE = 21;
        public final StatUtils.StatUtilsItemStat stat;
        public final ItemStack stack;
        public static final boolean SHOW_ITEM_NAMES = true;

        public BSStatWidget_Item(StatUtils.StatUtilsItemStat stat, int x, int y) {
            super(x, y, 21, 21);
            this.stat = stat;
            this.stack = stat.item.m_7968_();
            this.updateTooltip();
        }

        @Override
        public void updateTooltip() {
            String sMined = TextUtils.translatable((String)"stat_type.minecraft.mined", (Object[])new Object[0]).getString();
            String sCrafted = TextUtils.translatable((String)"stat_type.minecraft.crafted", (Object[])new Object[0]).getString();
            String sPicked = TextUtils.translatable((String)"stat_type.minecraft.picked_up", (Object[])new Object[0]).getString();
            String sDroppp = TextUtils.translatable((String)"stat_type.minecraft.dropped", (Object[])new Object[0]).getString();
            String sUsed = TextUtils.translatable((String)"stat_type.minecraft.used", (Object[])new Object[0]).getString();
            String sBroken = TextUtils.translatable((String)"stat_type.minecraft.broken", (Object[])new Object[0]).getString();
            MutableComponent tooltip = TextUtils.literal((String)(TextUtils.translatable((String)this.stat.item.m_5524_(), (Object[])new Object[0]).getString() + "\n\n" + sMined + " - " + this.stat.sMined + "\n" + sCrafted + " - " + this.stat.sCrafted + "\n" + sPicked + " - " + this.stat.sPickedUp + "\n" + sDroppp + " - " + this.stat.sDropped + "\n" + sUsed + " - " + this.stat.sUsed + "\n" + sBroken + " - " + this.stat.sBroken));
            this.setTooltip((Component)tooltip);
        }

        @Override
        public boolean mousePressed(int mouseX, int mouseY, int button) {
            String url;
            if (button == 2 && (url = BetterStatsRegistry.getItemWikiURL(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.stat.item))) != null) {
                GuiUtils.showUrlPrompt((String)url, (boolean)false);
                return false;
            }
            return super.mousePressed(mouseX, mouseY, button);
        }

        @Override
        public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
            super.render(matrices, mouseX, mouseY, deltaTime);
            this.getItemRenderer().m_115123_(this.stack, this.getTpeX() + 3, this.getTpeY() + 3);
        }
    }
}

