/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.registry;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BetterStatsRegistry {
    public static final Map<String, Function<ResourceLocation, String>> ITEM_WIKIS = new TreeMap<String, Function<ResourceLocation, String>>(String.CASE_INSENSITIVE_ORDER);
    public static final Map<String, Function<ResourceLocation, String>> MOB_WIKIS = new TreeMap<String, Function<ResourceLocation, String>>(String.CASE_INSENSITIVE_ORDER);

    protected BetterStatsRegistry() {
    }

    @Nullable
    public static String getItemWikiURL(ResourceLocation itemId) {
        Objects.requireNonNull(itemId, "itemId must not be null.");
        Function<ResourceLocation, String> supplier = ITEM_WIKIS.get(itemId.m_135827_());
        if (supplier == null) {
            return null;
        }
        return supplier.apply(itemId);
    }

    @Nullable
    public static String getMobWikiURL(ResourceLocation entityId) {
        Objects.requireNonNull(entityId, "entityId must not be null.");
        Function<ResourceLocation, String> supplier = MOB_WIKIS.get(entityId.m_135827_());
        if (supplier == null) {
            return null;
        }
        return supplier.apply(entityId);
    }

    static {
        String mc = new ResourceLocation("air").m_135827_();
        ITEM_WIKIS.put(mc, id -> "https://minecraft.fandom.com/wiki/" + id.m_135815_());
        MOB_WIKIS.put(mc, id -> "https://minecraft.fandom.com/wiki/" + id.m_135815_());
    }
}

