/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.member.ref.SetterMemberRef;
import org.openzen.zenscript.codemodel.scope.TypeScope;

public class StaticSetterExpression
extends Expression {
    public final SetterMemberRef setter;
    public final Expression value;

    public StaticSetterExpression(CodePosition position, SetterMemberRef setter, Expression value) {
        super(position, setter.getType(), value.thrownType);
        this.setter = setter;
        this.value = value;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitStaticSetter(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitStaticSetter(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        Expression tValue = this.value.transform(transformer);
        return tValue == this.value ? this : new StaticSetterExpression(this.position, this.setter, tValue);
    }

    @Override
    public Expression normalize(TypeScope scope) {
        return new StaticSetterExpression(this.position, this.setter, this.value.normalize(scope));
    }
}

