/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.block.material;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/block/material/Material")
@NativeTypeRegistration(value=Material.class, zenCodeName="crafttweaker.api.block.material.Material")
public class ExpandMaterial {
    public static final BiMap<String, Material> VANILLA_MATERIALS = (BiMap)Util.m_137469_((Object)HashBiMap.create(), map -> {
        map.put((Object)"AIR", (Object)Material.f_76296_);
        map.put((Object)"STRUCTURAL_AIR", (Object)Material.f_76297_);
        map.put((Object)"PORTAL", (Object)Material.f_76298_);
        map.put((Object)"CLOTH_DECORATION", (Object)Material.f_76299_);
        map.put((Object)"PLANT", (Object)Material.f_76300_);
        map.put((Object)"WATER_PLANT", (Object)Material.f_76301_);
        map.put((Object)"REPLACEABLE_PLANT", (Object)Material.f_76302_);
        map.put((Object)"REPLACEABLE_FIREPROOF_PLANT", (Object)Material.f_76303_);
        map.put((Object)"REPLACEABLE_WATER_PLANT", (Object)Material.f_76304_);
        map.put((Object)"WATER", (Object)Material.f_76305_);
        map.put((Object)"BUBBLE_COLUMN", (Object)Material.f_76306_);
        map.put((Object)"LAVA", (Object)Material.f_76307_);
        map.put((Object)"TOP_SNOW", (Object)Material.f_76308_);
        map.put((Object)"FIRE", (Object)Material.f_76309_);
        map.put((Object)"DECORATION", (Object)Material.f_76310_);
        map.put((Object)"WEB", (Object)Material.f_76311_);
        map.put((Object)"SCULK", (Object)Material.f_164533_);
        map.put((Object)"BUILDABLE_GLASS", (Object)Material.f_76312_);
        map.put((Object)"CLAY", (Object)Material.f_76313_);
        map.put((Object)"DIRT", (Object)Material.f_76314_);
        map.put((Object)"GRASS", (Object)Material.f_76315_);
        map.put((Object)"ICE_SOLID", (Object)Material.f_76316_);
        map.put((Object)"SAND", (Object)Material.f_76317_);
        map.put((Object)"SPONGE", (Object)Material.f_76318_);
        map.put((Object)"SHULKER_SHELL", (Object)Material.f_76319_);
        map.put((Object)"WOOD", (Object)Material.f_76320_);
        map.put((Object)"NETHER_WOOD", (Object)Material.f_76321_);
        map.put((Object)"BAMBOO_SAPLING", (Object)Material.f_76270_);
        map.put((Object)"BAMBOO", (Object)Material.f_76271_);
        map.put((Object)"WOOL", (Object)Material.f_76272_);
        map.put((Object)"EXPLOSIVE", (Object)Material.f_76273_);
        map.put((Object)"LEAVES", (Object)Material.f_76274_);
        map.put((Object)"GLASS", (Object)Material.f_76275_);
        map.put((Object)"ICE", (Object)Material.f_76276_);
        map.put((Object)"CACTUS", (Object)Material.f_76277_);
        map.put((Object)"STONE", (Object)Material.f_76278_);
        map.put((Object)"METAL", (Object)Material.f_76279_);
        map.put((Object)"SNOW", (Object)Material.f_76280_);
        map.put((Object)"HEAVY_METAL", (Object)Material.f_76281_);
        map.put((Object)"BARRIER", (Object)Material.f_76282_);
        map.put((Object)"PISTON", (Object)Material.f_76283_);
        map.put((Object)"MOSS", (Object)Material.f_164530_);
        map.put((Object)"VEGETABLE", (Object)Material.f_76285_);
        map.put((Object)"EGG", (Object)Material.f_76286_);
        map.put((Object)"CAKE", (Object)Material.f_76287_);
        map.put((Object)"AMETHYST", (Object)Material.f_164531_);
        map.put((Object)"POWDER_SNOW", (Object)Material.f_164532_);
    });

    public static Optional<Material> getOptionalMaterial(String tokens) {
        return Optional.ofNullable((Material)VANILLA_MATERIALS.get((Object)tokens));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isLiquid")
    public static boolean isLiquid(Material internal) {
        return internal.m_76332_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSolid")
    public static boolean isSolid(Material internal) {
        return internal.m_76333_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="blocksMotion")
    public static boolean blocksMotion(Material internal) {
        return internal.m_76334_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isFlammable")
    public static boolean isFlammable(Material internal) {
        return internal.m_76335_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isReplaceable")
    public static boolean isReplaceable(Material internal) {
        return internal.m_76336_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSolidBlocking")
    public static boolean isSolidBlocking(Material internal) {
        return internal.m_76337_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="pushReaction")
    public static PushReaction getPushReaction(Material internal) {
        return internal.m_76338_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="color")
    public static MaterialColor getColor(Material internal) {
        return internal.m_76339_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(Material internal) {
        BiMap inverse = VANILLA_MATERIALS.inverse();
        String name = (String)inverse.getOrDefault((Object)internal, (Object)"UNKNOWN");
        return "<material:" + name.toLowerCase(Locale.ROOT) + ">";
    }
}

