/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script.scriptrun.runner;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.zencode.scriptrun.IScriptRunInfo;
import com.blamejared.crafttweaker.impl.script.scriptrun.runner.ScriptRunner;
import com.blamejared.crafttweaker.platform.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.openzen.zencode.java.logger.ScriptingEngineLogger;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.ScriptBlock;
import org.openzen.zenscript.codemodel.SemanticModule;
import org.openzen.zenscript.formatter.FileFormatter;
import org.openzen.zenscript.formatter.ScriptFormattingSettings;

final class FormattingScriptRunner
extends ScriptRunner {
    FormattingScriptRunner(IScriptRunInfo runInfo, List<SourceFile> sources, ScriptingEngineLogger logger) {
        super(runInfo, sources, logger);
    }

    @Override
    protected void executeRunAction(SemanticModule module) {
        this.format(module);
        if (!this.runInfo().dumpClasses()) {
            return;
        }
        Path classes = Services.PLATFORM.getPathFromGameDirectory("classes");
        this.engine().createRunUnit().dump(classes.toFile());
    }

    private void format(SemanticModule module) {
        List<HighLevelDefinition> definitions = module.definitions.getAll();
        ScriptFormattingSettings.Builder builder = new ScriptFormattingSettings.Builder();
        FileFormatter formatter = new FileFormatter(builder.build());
        Path formattedScriptsDirectory = Services.PLATFORM.getPathFromGameDirectory("scriptsFormatted");
        module.scripts.forEach(block -> {
            String format = formatter.format(module.rootPackage, (ScriptBlock)block, definitions);
            Path file = formattedScriptsDirectory.resolve(block.file.getFilename());
            Path parent = file.getParent();
            if (!Files.isDirectory(parent, new LinkOption[0])) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (IOException e) {
                    CraftTweakerAPI.LOGGER.error("Unable to create directory {}, aborting", (Object)file.getParent());
                    return;
                }
            }
            try {
                Files.write(file, Arrays.asList(format.split(System.lineSeparator())), new OpenOption[0]);
            }
            catch (IOException e) {
                CraftTweakerAPI.LOGGER.error("Unable to write formatted files", (Throwable)e);
            }
        });
    }
}

