/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.util.sequence.SequenceManager;
import com.blamejared.crafttweaker.api.util.sequence.SequenceType;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptRunConfiguration;
import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.blamejared.crafttweaker.impl.script.scriptrun.ThroughRecipeScriptRunManager;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.item.crafting.RecipeManager;

public class RecipeManagerScriptLoader {
    private static UpdatedState currentState = UpdatedState.NONE;
    private static RecipeManager manager = null;

    public static void updateState(UpdatedState state, @Nullable Supplier<RecipeManager> managerSupplier) {
        if (currentState.hasAll()) {
            currentState = UpdatedState.NONE;
            manager = null;
            throw new IllegalArgumentException("Invalid state found in RecipeManagerScriptLoader!");
        }
        currentState = currentState.merge(state);
        if (managerSupplier != null) {
            manager = managerSupplier.get();
        }
        if (currentState.hasAll()) {
            if (manager == null) {
                throw new RuntimeException("State is ready, but manager is null!");
            }
            RecipeManagerScriptLoader.loadScriptsFromManager(manager);
            currentState = UpdatedState.NONE;
            manager = null;
        }
    }

    public static void loadScriptsFromManager(RecipeManager manager) {
        SequenceManager.clearSequences(SequenceType.CLIENT_THREAD_LEVEL);
        if (Services.CLIENT.isSingleplayer()) {
            return;
        }
        RecipeManagerScriptLoader.fixRecipeManager(manager);
        Map recipes = ((AccessRecipeManager)manager).crafttweaker$getRecipes().getOrDefault(CraftTweakerRegistries.RECIPE_TYPE_SCRIPTS, Collections.emptyMap());
        if (recipes.isEmpty()) {
            return;
        }
        List<ScriptRecipe> scriptRecipes = recipes.values().stream().map(ScriptRecipe.class::cast).toList();
        ScriptRunConfiguration configuration = new ScriptRunConfiguration("crafttweaker", CraftTweakerConstants.CLIENT_RECIPES_UPDATED_SOURCE_ID, ScriptRunConfiguration.RunKind.EXECUTE);
        try {
            ThroughRecipeScriptRunManager.createScriptRunFromRecipes(scriptRecipes, configuration).execute();
        }
        catch (Throwable e) {
            CraftTweakerAPI.LOGGER.error("Unable to execute script run", e);
        }
    }

    private static void fixRecipeManager(RecipeManager manager) {
        AccessRecipeManager accessRecipeManager = (AccessRecipeManager)manager;
        accessRecipeManager.crafttweaker$setRecipes(new HashMap(accessRecipeManager.crafttweaker$getRecipes()));
        accessRecipeManager.crafttweaker$getRecipes().replaceAll((k, v) -> new HashMap(accessRecipeManager.crafttweaker$getRecipes().get(k)));
        accessRecipeManager.crafttweaker$setByName(new HashMap(accessRecipeManager.crafttweaker$getByName()));
        CraftTweakerAPI.getAccessibleElementsProvider().recipeManager(manager);
    }

    public static enum UpdatedState {
        NONE(false, false),
        RECIPES(true, false),
        TAGS(false, true),
        ALL(true, true);

        private final boolean hasRecipes;
        private final boolean hasTags;

        private UpdatedState(boolean hasRecipes, boolean hasTags) {
            this.hasRecipes = hasRecipes;
            this.hasTags = hasTags;
        }

        public boolean hasRecipes() {
            return this.hasRecipes;
        }

        public boolean hasTags() {
            return this.hasTags;
        }

        public boolean hasAll() {
            return this.hasRecipes && this.hasTags;
        }

        public static UpdatedState of(boolean hasRecipes, boolean hasTags) {
            if (hasRecipes) {
                if (hasTags) {
                    return ALL;
                }
                return RECIPES;
            }
            if (hasTags) {
                return TAGS;
            }
            return NONE;
        }

        public UpdatedState merge(UpdatedState other) {
            return UpdatedState.of(this.hasRecipes || other.hasRecipes, this.hasTags || other.hasTags);
        }
    }
}

