/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.crafttweaker;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.type.CTShapelessRecipeBase;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=CTShapelessRecipeBase.class)
public final class CTShapelessRecipeHandler
implements IRecipeHandler<CTShapelessRecipeBase> {
    @Override
    public String dumpToCommandString(IRecipeManager manager, CTShapelessRecipeBase recipe) {
        return String.format("craftingTable.addShapeless(%s, %s, %s%s);", StringUtil.quoteAndEscape(recipe.m_6423_()), recipe.getCtOutput().getCommandString(), Arrays.stream(recipe.getCtIngredients()).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]")), recipe.getFunction() == null ? "" : ", (usualOut, inputs) => { ... }");
    }

    @Override
    public Optional<Function<ResourceLocation, CTShapelessRecipeBase>> replaceIngredients(IRecipeManager manager, CTShapelessRecipeBase recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceIngredientArray(recipe.getCtIngredients(), IIngredient.class, recipe, rules, newIngredients -> id -> Services.REGISTRY.createCTShapelessRecipe(id.m_135815_(), recipe.getCtOutput(), (IIngredient[])newIngredients, recipe.getFunction()));
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager manager, CTShapelessRecipeBase firstRecipe, U secondRecipe) {
        return Services.PLATFORM.doCraftingTableRecipesConflict(manager, (Recipe<?>)firstRecipe, secondRecipe);
    }
}

