/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public final class ItemStackUtil {
    public static String getCommandString(ItemStack stack) {
        return ItemStackUtil.getCommandString(stack, false);
    }

    public static String getCommandString(ItemStack stack, boolean mutable) {
        StringBuilder sb = new StringBuilder("<item:");
        sb.append(Services.REGISTRY.getRegistryKey(stack.m_41720_()));
        sb.append('>');
        if (stack.m_41783_() != null) {
            MapData data = TagToDataConverter.convertCompound(stack.m_41783_()).copyInternal();
            if (stack.m_41720_().m_41465_()) {
                data.remove("Damage");
            }
            if (!data.isEmpty()) {
                sb.append(".withTag(");
                sb.append(data.asString());
                sb.append(')');
            }
        }
        if (stack.m_41773_() > 0) {
            sb.append(".withDamage(").append(stack.m_41773_()).append(')');
        }
        if (!stack.m_41619_() && stack.m_41613_() != 1) {
            sb.append(" * ").append(stack.m_41613_());
        }
        if (mutable) {
            sb.append(".mutable()");
        }
        return sb.toString();
    }

    public static boolean areStacksTheSame(ItemStack first, ItemStack second) {
        if (first.m_41619_() != second.m_41619_()) {
            return false;
        }
        if (first.m_41720_() != second.m_41720_()) {
            return false;
        }
        if (first.m_41613_() > second.m_41613_()) {
            return false;
        }
        if (first.m_41773_() != second.m_41773_()) {
            return false;
        }
        CompoundTag firstTag = first.m_41783_();
        CompoundTag secondTag = second.m_41783_();
        if (firstTag == null) {
            return true;
        }
        if (secondTag == null) {
            return false;
        }
        return firstTag.equals((Object)secondTag);
    }
}

