/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.rule;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public final class FullIngredientReplacementRule
implements IReplacementRule {
    private final IIngredient from;
    private final IIngredient to;

    private FullIngredientReplacementRule(IIngredient from, IIngredient to) {
        this.from = from;
        this.to = to;
    }

    public static IReplacementRule create(IIngredient from, IIngredient to) {
        return FullIngredientReplacementRule.areTheSame(from, to) ? IReplacementRule.EMPTY : new FullIngredientReplacementRule(from, to);
    }

    private static boolean areTheSame(IIngredient a, IIngredient b) {
        return a == b || Objects.equals(a, b) || a.contains(b) && b.contains(a);
    }

    @Override
    public <T, U extends Recipe<?>> Optional<T> getReplacement(T ingredient, Class<T> type, U recipe) {
        return IReplacementRule.chain(IReplacementRule.withType(ingredient, type, recipe, IIngredient.class, this::getIIngredientReplacement), IReplacementRule.withType(ingredient, type, recipe, Ingredient.class, this::getIngredientReplacement));
    }

    private <U extends Recipe<?>> Optional<IIngredient> getIIngredientReplacement(IIngredient ingredient, U recipe) {
        return FullIngredientReplacementRule.areTheSame(this.from, ingredient) ? Optional.of(this.to) : Optional.empty();
    }

    private <U extends Recipe<?>> Optional<Ingredient> getIngredientReplacement(Ingredient ingredient, U recipe) {
        return this.getIIngredientReplacement(IIngredient.fromIngredient(ingredient), recipe).map(IIngredient::asVanillaIngredient);
    }

    @Override
    public String describe() {
        return String.format("Replacing fully %s --> %s", this.from.getCommandString(), this.to.getCommandString());
    }
}

