/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.level;

import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.level.FakeChunkCache;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.level.listener.LevelBoundsListener;
import team.creative.creativecore.common.level.system.BlockUpdateLevelSystem;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;

public abstract class CreativeLevel
extends Level
implements IOrientatedLevel {
    public Entity holder;
    public IVecOrigin origin;
    private final FakeChunkCache chunkSource;
    public final BlockUpdateLevelSystem blockUpdate = new BlockUpdateLevelSystem(this);
    public boolean hasChanged = false;
    public boolean preventNeighborUpdate = false;

    protected CreativeLevel(WritableLevelData worldInfo, int radius, Supplier<ProfilerFiller> supplier, boolean client, boolean debug, long seed) {
        super(worldInfo, CreativeCore.FAKE_DIMENSION_NAME, CreativeCore.FAKE_DIMENSION, supplier, client, debug, seed);
        this.chunkSource = new FakeChunkCache(this, radius);
    }

    @Override
    public Entity getHolder() {
        return this.holder;
    }

    @Override
    public void setHolder(Entity entity) {
        this.holder = entity;
    }

    public void registerLevelBoundListener(LevelBoundsListener listener) {
        this.blockUpdate.registerLevelBoundListener(listener);
    }

    public void m_46586_(BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.preventNeighborUpdate) {
            return;
        }
        if (this.f_46443_) {
            BlockState blockstate = this.m_8055_(pos);
            try {
                blockstate.m_60690_((Level)this, pos, blockIn, fromPos, false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being updated");
                crashreportcategory.m_128165_("Source block type", () -> {
                    try {
                        return String.format("ID #%s (%s // %s)", blockIn.getRegistryName(), blockIn.m_7705_(), blockIn.getClass().getCanonicalName());
                    }
                    catch (Throwable throwable1) {
                        return "ID #" + blockIn.getRegistryName();
                    }
                });
                CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)this, (BlockPos)pos, (BlockState)blockstate);
                throw new ReportedException(crashreport);
            }
        } else {
            super.m_46586_(pos, blockIn, fromPos);
        }
    }

    public void m_46590_(BlockPos pos, Block block, Direction facing) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.m_46590_(pos, block, facing);
    }

    public void m_46672_(BlockPos pos, Block block) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.m_46672_(pos, block);
    }

    public BlockPos transformToRealWorld(BlockPos pos) {
        return this.getOrigin().transformPointToWorld(pos);
    }

    public FakeChunkCache getChunkSource() {
        return this.chunkSource;
    }

    public void unload(LevelChunk chunk) {
        chunk.m_187957_();
        this.chunkSource.m_7827_().m_141940_(chunk.m_7697_(), false);
    }

    public void onChunkLoaded(ChunkPos pos) {
    }

    public void m_7260_(BlockPos pos, BlockState state, BlockState p_184138_3_, int p_184138_4_) {
        this.hasChanged = true;
    }

    public Iterable<Entity> loadedEntities() {
        return this.m_142646_().m_142273_();
    }

    public int m_7354_() {
        return 0;
    }

    public void m_6801_(int p_175715_1_, BlockPos p_175715_2_, int p_175715_3_) {
    }

    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }
}

