/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.level;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.client.render.level.IRenderChunkSupplier;
import team.creative.creativecore.common.level.CreativeLevel;

public abstract class CreativeClientLevel
extends CreativeLevel {
    public IRenderChunkSupplier renderChunkSupplier;
    final EntityTickList tickingEntities = new EntityTickList();
    private final TransientEntitySectionManager<Entity> entityStorage = new TransientEntitySectionManager(Entity.class, (LevelCallback)new EntityCallbacks());
    final List<AbstractClientPlayer> players = Lists.newArrayList();
    private final Map<String, MapItemSavedData> mapData = Maps.newHashMap();

    protected CreativeClientLevel(WritableLevelData worldInfo, int radius, Supplier<ProfilerFiller> supplier, boolean debug, long seed) {
        super(worldInfo, radius, supplier, true, debug, seed);
    }

    public List<? extends Player> m_6907_() {
        return this.players;
    }

    public Entity m_6815_(int id) {
        return (Entity)this.m_142646_().m_142597_(id);
    }

    public LevelEntityGetter<Entity> m_142646_() {
        return this.entityStorage.m_157645_();
    }

    public String m_46464_() {
        return "Chunks[C] W: " + this.getChunkSource().m_6754_() + " E: " + this.entityStorage.m_157664_();
    }

    public MapItemSavedData m_7489_(String data) {
        return this.mapData.get(data);
    }

    public void m_142325_(String id, MapItemSavedData data) {
        this.mapData.put(id, data);
    }

    final class EntityCallbacks
    implements LevelCallback<Entity> {
        EntityCallbacks() {
        }

        public void onCreated(Entity entity) {
        }

        public void onDestroyed(Entity entity) {
        }

        public void onTickingStart(Entity entity) {
            CreativeClientLevel.this.tickingEntities.m_156908_(entity);
        }

        public void onTickingEnd(Entity entity) {
            CreativeClientLevel.this.tickingEntities.m_156912_(entity);
        }

        public void onTrackingStart(Entity entity) {
            if (entity instanceof AbstractClientPlayer) {
                CreativeClientLevel.this.players.add((AbstractClientPlayer)entity);
            }
        }

        public void onTrackingEnd(Entity entity) {
            entity.m_19877_();
            CreativeClientLevel.this.players.remove(entity);
            entity.onRemovedFromWorld();
            MinecraftForge.EVENT_BUS.post((Event)new EntityLeaveWorldEvent(entity, (Level)CreativeClientLevel.this));
        }
    }
}

