/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.teamabnormals.savage_and_ravage.common.entity.monster.Iceologer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractIllager;

public class IceologerModel
extends HumanoidModel<Iceologer> {
    private final ModelPart arms;
    private final ModelPart cape;

    public IceologerModel(ModelPart root) {
        super(root);
        this.f_102809_.f_104207_ = false;
        this.arms = root.m_171324_("arms");
        this.cape = root.m_171324_("cape");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171506_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, false).m_171514_(0, 38).m_171488_(-4.0f, 1.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, false).m_171514_(24, 0).m_171506_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, false).m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        PartDefinition leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171506_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, true), PartPose.m_171423_((float)-5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171506_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, false), PartPose.m_171423_((float)5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171506_(2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, true), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171506_(-6.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, false), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arms = root.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(40, 38).m_171506_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, false).m_171514_(44, 22).m_171506_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, false).m_171514_(44, 22).m_171506_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, true), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cape = root.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(19, 43).m_171506_(-4.0f, -18.0f, -0.5f, 8.0f, 18.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)3.5f, (float)-0.2618f, (float)0.0f, (float)3.1416f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(Iceologer entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        double d0 = entity.prevChasingPosX + (entity.chasingPosX - entity.prevChasingPosX) * (double)partialTicks - (entity.f_19854_ + (entity.m_20185_() - entity.f_19854_) * (double)partialTicks);
        double d1 = entity.prevChasingPosY + (entity.chasingPosY - entity.prevChasingPosY) * (double)partialTicks - (entity.f_19855_ + (entity.m_20186_() - entity.f_19855_) * (double)partialTicks);
        double d2 = entity.prevChasingPosZ + (entity.chasingPosZ - entity.prevChasingPosZ) * (double)partialTicks - (entity.f_19856_ + (entity.m_20189_() - entity.f_19856_) * (double)partialTicks);
        float f = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTicks;
        double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float f1 = (float)d1 * 10.0f;
        f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
        float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
        f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f);
        float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
        f3 = Mth.m_14036_((float)f3, (float)-20.0f, (float)20.0f);
        float f4 = entity.prevCameraYaw + (entity.cameraYaw - entity.prevCameraYaw) * partialTicks;
        f1 += Mth.m_14031_((float)((entity.f_19867_ + (entity.f_19787_ - entity.f_19867_) * partialTicks) * 6.0f)) * 32.0f * f4;
        if (entity.m_6144_()) {
            f1 += 25.0f;
        }
        this.cape.f_104203_ = (float)Math.toRadians(180.0f - (6.0f + f2 / 2.0f + f1));
        this.cape.f_104204_ = (float)Math.toRadians(180.0f - f3 / 2.0f);
        this.cape.f_104205_ = (float)Math.toRadians(f3 / 2.0f);
        super.m_6839_((LivingEntity)entity, limbSwing, limbSwingAmount, partialTicks);
    }

    public void setupAnim(Iceologer entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        super.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.arms.f_104201_ = 3.0f;
        this.arms.f_104202_ = -1.0f;
        this.arms.f_104203_ = -0.75f;
        AbstractIllager.IllagerArmPose armPose = entity.m_6768_();
        if (armPose == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (entity.m_21205_().m_41619_()) {
                AnimationUtils.m_102102_((ModelPart)this.f_102812_, (ModelPart)this.f_102811_, (boolean)true, (float)this.f_102608_, (float)ageInTicks);
            } else {
                AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (Mob)entity, (float)this.f_102608_, (float)ageInTicks);
            }
        } else if (armPose == AbstractIllager.IllagerArmPose.SPELLCASTING) {
            this.f_102811_.f_104202_ = 0.0f;
            this.f_102811_.f_104200_ = -5.0f;
            this.f_102812_.f_104202_ = 0.0f;
            this.f_102812_.f_104200_ = 5.0f;
            this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.f_102811_.f_104205_ = 2.3561945f;
            this.f_102812_.f_104205_ = -2.3561945f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102812_.f_104204_ = 0.0f;
        } else if (armPose == AbstractIllager.IllagerArmPose.BOW_AND_ARROW) {
            this.f_102811_.f_104204_ = -0.1f + this.f_102808_.f_104204_;
            this.f_102811_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
            this.f_102812_.f_104203_ = -0.9424779f + this.f_102808_.f_104203_;
            this.f_102812_.f_104204_ = this.f_102808_.f_104204_ - 0.4f;
            this.f_102812_.f_104205_ = 1.5707964f;
        } else if (armPose == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            AnimationUtils.m_102097_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (ModelPart)this.f_102808_, (boolean)true);
        } else if (armPose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.m_102086_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (LivingEntity)entity, (boolean)true);
        } else if (armPose == AbstractIllager.IllagerArmPose.CELEBRATING) {
            this.f_102811_.f_104202_ = 0.0f;
            this.f_102811_.f_104200_ = -5.0f;
            this.f_102811_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.f_102811_.f_104205_ = 2.670354f;
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102812_.f_104202_ = 0.0f;
            this.f_102812_.f_104200_ = 5.0f;
            this.f_102812_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.f_102812_.f_104205_ = -2.3561945f;
            this.f_102812_.f_104204_ = 0.0f;
        }
        this.arms.f_104207_ = flag = armPose == AbstractIllager.IllagerArmPose.CROSSED;
        this.f_102812_.f_104207_ = !flag;
        this.f_102811_.f_104207_ = !flag;
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.arms, (Object)this.cape));
    }
}

