/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.utils;

import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.improvedmobs.utils.CustomBlockCollision;
import io.github.flemmli97.improvedmobs.utils.Utils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PathFindingUtils {
    public static Node notFloatingNodeModifier(Mob mob, BlockGetter getter, int x, int y, int z, int stepModifier, Direction dir, BlockPathTypes standingType, Function<BlockPos, BlockPathTypes> func, Function<AABB, Boolean> collision, Function<AABB, Boolean> collisionDefault, Function<BlockPos, Node> nodeGetter, Object2BooleanMap<Long> breakableMap) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        BlockState state = getter.m_8055_((BlockPos)pos);
        if (breakableMap.computeIfAbsent((Object)BlockPos.m_121882_((int)x, (int)y, (int)z), p -> PathFindingUtils.canBreak(state, (BlockPos)pos, mob))) {
            AABB aabb = PathFindingUtils.createAABBForPos(getter, x, y, z, (double)mob.m_20205_() / 2.0, mob.m_20206_());
            if (stepModifier > 0 && !collisionDefault.apply(aabb.m_82363_((double)(-dir.m_122429_()), 0.0, (double)(-dir.m_122431_()))).booleanValue()) {
                Node node = nodeGetter.apply((BlockPos)pos.m_122178_(x, y + 1, z));
                node.f_77282_ = BlockPathTypes.WALKABLE;
                node.f_77281_ = Math.max(0.0f, node.f_77281_);
                return node;
            }
            if (collision.apply(aabb.m_82386_(0.0, -1.0, 0.0)).booleanValue()) {
                return null;
            }
            Node node = nodeGetter.apply((BlockPos)pos);
            node.f_77282_ = BlockPathTypes.WALKABLE;
            node.f_77281_ = Math.max(0.0f, node.f_77281_);
            BlockPathTypes below = func.apply((BlockPos)pos.m_122178_(x, y - 1, z));
            if (below == BlockPathTypes.OPEN) {
                int fall = 0;
                BlockPos.MutableBlockPos lower = new BlockPos.MutableBlockPos(x, y, z);
                while (below == BlockPathTypes.OPEN) {
                    if (--y < mob.f_19853_.m_141937_()) {
                        return null;
                    }
                    if (fall++ >= mob.m_6056_()) {
                        Node node2 = nodeGetter.apply((BlockPos)lower.m_122178_(x, y, z));
                        node2.f_77282_ = BlockPathTypes.BLOCKED;
                        node2.f_77281_ = -1.0f;
                        return node2;
                    }
                    below = func.apply((BlockPos)lower.m_122178_(x, y, z));
                    float mobPathingMalus = mob.m_21439_(below);
                    if (below != BlockPathTypes.OPEN && mobPathingMalus >= 0.0f) {
                        node = nodeGetter.apply((BlockPos)lower.m_122178_(x, y, z));
                        node.f_77282_ = below;
                        node.f_77281_ = Math.max(node.f_77281_, mobPathingMalus);
                        break;
                    }
                    if (!(mobPathingMalus < 0.0f)) continue;
                    return null;
                }
            }
            node.f_77281_ += 6.0f;
            return node;
        }
        if (stepModifier > 0) {
            BlockState above = getter.m_8055_((BlockPos)pos.m_122178_(x, y + 1, z));
            if (!breakableMap.computeIfAbsent((Object)BlockPos.m_121882_((int)x, (int)(y + 1), (int)z), p -> PathFindingUtils.canBreak(above, (BlockPos)pos, mob))) {
                return null;
            }
            AABB aabb = PathFindingUtils.createAABBForPos(getter, x, y + 1, z, (double)mob.m_20205_() / 2.0, mob.m_20206_());
            if (collision.apply(aabb).booleanValue()) {
                return null;
            }
            Node node = nodeGetter.apply((BlockPos)pos.m_122178_(x, y, z));
            node.f_77281_ = Math.max(0.0f, node.f_77281_);
            node.f_77282_ = BlockPathTypes.WALKABLE;
            node.f_77281_ += 6.0f;
            return node;
        }
        return null;
    }

    public static Node floatingNodeModifier(Mob mob, BlockGetter getter, int x, int y, int z, Function<AABB, Boolean> collision, Function<BlockPos, Node> nodeGetter) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        BlockState state = getter.m_8055_((BlockPos)pos);
        if (PathFindingUtils.canBreak(state, (BlockPos)pos, mob)) {
            AABB aabb = PathFindingUtils.createAABBForPos(getter, x, y, z, (double)mob.m_20205_() / 2.0, mob.m_20206_());
            if (collision.apply(aabb).booleanValue()) {
                return null;
            }
            Node node = nodeGetter.apply((BlockPos)pos);
            node.f_77282_ = BlockPathTypes.WALKABLE;
            node.f_77281_ += 2.0f;
            return node;
        }
        return null;
    }

    public static boolean noCollision(PathNavigationRegion level, Entity entity, AABB aABB) {
        Iterable shapes = () -> new CustomBlockCollision((CollisionGetter)level, entity, aABB);
        for (VoxelShape voxelShape : shapes) {
            if (voxelShape.m_83281_()) continue;
            return false;
        }
        if (entity != null) {
            WorldBorder worldBorder = level.m_6857_();
            VoxelShape voxelShape2 = worldBorder.m_187566_(entity, aABB) ? worldBorder.m_61946_() : null;
            return voxelShape2 == null || !Shapes.m_83157_((VoxelShape)voxelShape2, (VoxelShape)Shapes.m_83064_((AABB)aABB), (BooleanOp)BooleanOp.f_82689_);
        }
        return true;
    }

    public static AABB createAABBForPos(BlockGetter getter, int x, int y, int z, double widthHalf, double height) {
        double floor1 = WalkNodeEvaluator.m_77611_((BlockGetter)getter, (BlockPos)new BlockPos(x, y + 1, z));
        return new AABB((double)x - widthHalf + 0.5, floor1 + 0.001, (double)z - widthHalf + 0.5, (double)x + widthHalf + 0.5, height + floor1, (double)z + widthHalf + 0.5);
    }

    public static int createLadderNodeFor(int nodeID, Node[] nodes, Node origin, Function<BlockPos, Node> nodeGetter, BlockGetter getter, Mob mob) {
        Node node;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(origin.f_77271_, origin.f_77272_ + 1, origin.f_77273_);
        if (CrossPlatformStuff.INSTANCE.isLadder(getter.m_8055_((BlockPos)pos), (LivingEntity)mob, (BlockPos)pos) && (node = nodeGetter.apply((BlockPos)pos)) != null && !node.f_77279_) {
            node.f_77281_ = 0.0f;
            node.f_77282_ = BlockPathTypes.WALKABLE;
            if (nodeID + 1 < nodes.length) {
                nodes[nodeID++] = node;
            }
        }
        pos.m_122178_(pos.m_123341_(), pos.m_123342_() - 2, pos.m_123343_());
        if (CrossPlatformStuff.INSTANCE.isLadder(getter.m_8055_((BlockPos)pos), (LivingEntity)mob, (BlockPos)pos) && (node = nodeGetter.apply((BlockPos)pos)) != null && !node.f_77279_) {
            node.f_77281_ = 0.0f;
            node.f_77282_ = BlockPathTypes.WALKABLE;
            if (nodeID + 1 < nodes.length) {
                nodes[nodeID++] = node;
            }
        }
        return nodeID;
    }

    public static boolean canBreak(BlockPos pos, Mob entity) {
        return PathFindingUtils.canBreak(entity.f_19853_.m_8055_(pos), pos, entity);
    }

    private static boolean canBreak(BlockState state, BlockPos pos, Mob entity) {
        return Config.CommonConfig.breakableBlocks.canBreak(state, pos, (BlockGetter)entity.f_19853_, (Entity)entity, CollisionContext.m_82750_((Entity)entity)) && (Utils.canHarvest(state, entity.m_21205_()) || Utils.canHarvest(state, entity.m_21206_()));
    }
}

