/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.forge.network;

import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.difficulty.IPlayerDifficulty;
import io.github.flemmli97.improvedmobs.forge.network.PacketConfig;
import io.github.flemmli97.improvedmobs.forge.network.PacketDifficulty;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final ResourceLocation channelID = new ResourceLocation("improvedmobs", "packets");
    private static final SimpleChannel dispatcher = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("improvedmobs", "packets")).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "v1.0").simpleChannel();

    public static void register() {
        int id = 0;
        dispatcher.registerMessage(id++, PacketDifficulty.class, PacketDifficulty::write, PacketDifficulty::read, PacketDifficulty::handle);
        dispatcher.registerMessage(id++, PacketConfig.class, PacketConfig::write, PacketConfig::read, PacketConfig::handle);
    }

    public static <T> void sendDifficultyToClient(DifficultyData data, ServerPlayer player) {
        if (PacketHandler.hasChannel(player)) {
            dispatcher.sendTo((Object)new PacketDifficulty(Config.CommonConfig.difficultyType == Config.DifficultyType.GLOBAL ? data.getDifficulty() : CrossPlatformStuff.INSTANCE.getPlayerDifficultyData(player).map(IPlayerDifficulty::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue()), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static <T> void sendDifficultyToAll(DifficultyData data, MinecraftServer server) {
        if (Config.CommonConfig.difficultyType == Config.DifficultyType.GLOBAL) {
            Packet pkt = dispatcher.toVanillaPacket((Object)new PacketDifficulty(data.getDifficulty()), NetworkDirection.PLAY_TO_CLIENT);
            server.m_6846_().m_11314_().forEach(player -> {
                if (PacketHandler.hasChannel(player)) {
                    player.f_8906_.m_141995_(pkt);
                }
            });
        } else {
            server.m_6846_().m_11314_().forEach(player -> {
                if (PacketHandler.hasChannel(player)) {
                    float diff = Config.CommonConfig.difficultyType.increaseDifficulty ? CrossPlatformStuff.INSTANCE.getPlayerDifficultyData((ServerPlayer)player).map(IPlayerDifficulty::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue() : DifficultyData.getDifficultyFromDist(player.m_183503_(), player.m_20182_());
                    player.f_8906_.m_141995_(dispatcher.toVanillaPacket((Object)new PacketDifficulty(diff), NetworkDirection.PLAY_TO_CLIENT));
                }
            });
        }
    }

    public static <T> void sendConfigSync(ServerPlayer player) {
        if (PacketHandler.hasChannel(player)) {
            dispatcher.sendTo((Object)new PacketConfig(), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private static boolean hasChannel(ServerPlayer player) {
        ConnectionData data = NetworkHooks.getConnectionData((Connection)player.f_8906_.f_9742_);
        return data != null && data.getChannels().containsKey((Object)channelID);
    }
}

