/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.entities;

import io.github.flemmli97.improvedmobs.entities.RiddenSummonEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FlyingSummonEntity
extends RiddenSummonEntity {
    public static final ResourceLocation SUMMONED_FLYING_ID = new ResourceLocation("improvedmobs", "flying_entity");
    private static final EntityDataAccessor<Integer> DATA_ID_SIZE = SynchedEntityData.m_135353_(FlyingSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public FlyingSummonEntity(Level level) {
        super((EntityType<? extends Mob>)EntityType.f_20509_, level);
        if (!level.f_46443_) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.2);
            this.m_21051_(Attributes.f_22277_).m_22100_(24.0);
        }
        this.f_21342_ = new CustomFlyMoveControl(this);
        this.m_20242_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_SIZE, (Object)-1);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation(this, level){

            public boolean m_6342_(BlockPos pos) {
                return true;
            }
        };
        flyingPathNavigation.m_26440_(false);
        flyingPathNavigation.m_7008_(true);
        flyingPathNavigation.m_26443_(true);
        return flyingPathNavigation;
    }

    @Override
    public EntityDimensions originDimension(Pose pose) {
        int i = (Integer)this.f_19804_.m_135370_(DATA_ID_SIZE);
        EntityDimensions entityDimensions = super.originDimension(pose);
        float f = (entityDimensions.f_20377_ + 0.2f * (float)i) / entityDimensions.f_20377_;
        return entityDimensions.m_20388_(f);
    }

    public double m_6048_() {
        return this.m_6095_().m_20680_().f_20378_ * 0.35f;
    }

    @Override
    protected void m_20348_(Entity passenger) {
        if (this.m_20197_().isEmpty()) {
            float widthPassenger = passenger.m_20205_();
            int w = (int)((widthPassenger - 0.8f) / 0.2f);
            this.f_19804_.m_135381_(DATA_ID_SIZE, (Object)w);
            if (passenger instanceof Mob) {
                Mob mob = (Mob)passenger;
                ((FlyingPathNavigation)this.m_21573_()).m_26440_(mob.m_21573_().m_26575_().m_77360_());
            }
        }
        super.m_20348_(passenger);
    }

    @Override
    public ResourceLocation serverSideID() {
        return SUMMONED_FLYING_ID;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_ID_SIZE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20069_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        } else if (this.m_20077_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            float friction = 0.91f;
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)friction));
        }
        this.m_21043_((LivingEntity)this, false);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12231_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    public float m_6100_() {
        return super.m_6100_() * 0.8f;
    }

    protected static class CustomFlyMoveControl
    extends MoveControl {
        private float speed = 0.1f;

        public CustomFlyMoveControl(FlyingSummonEntity mob) {
            super((Mob)mob);
        }

        public void m_8126_() {
            BlockPos target;
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.f_24974_.m_21573_().m_26571_()) {
                this.f_24974_.m_7910_(0.0f);
                return;
            }
            if (this.f_24974_.f_19862_) {
                this.f_24974_.m_146922_(this.f_24974_.m_146908_() + 180.0f);
                this.speed = 0.1f;
            }
            Vec3 dir = new Vec3(this.f_24975_ - this.f_24974_.m_20185_(), this.f_24976_ - this.f_24974_.m_20186_(), this.f_24977_ - this.f_24974_.m_20189_());
            dir = dir.m_82541_();
            float rotPre = this.f_24974_.m_146908_();
            double horLen = Math.sqrt(dir.m_7096_() * dir.m_7096_() + dir.m_7094_() * dir.m_7094_());
            this.f_24974_.m_146926_(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)dir.m_7098_(), (double)horLen) * 57.2957763671875)))));
            float newRot = Mth.m_14177_((float)((float)(Mth.m_14136_((double)dir.m_7094_(), (double)dir.m_7096_()) * 57.2957763671875)));
            this.f_24974_.m_146922_(Mth.m_14148_((float)(rotPre + 90.0f), (float)newRot, (float)8.0f) - 90.0f);
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            float throttleTreshold = 12.0f;
            if (!this.f_24974_.m_21573_().m_26571_() && this.f_24974_.m_20275_((double)(target = this.f_24974_.m_21573_().m_26570_().m_77406_()).m_123341_() + 0.5, (double)target.m_123342_(), (double)target.m_123343_() + 0.5) < 4.5) {
                throttleTreshold = 3.0f;
            }
            this.speed = Mth.m_14145_((float)rotPre, (float)this.f_24974_.m_146908_()) < throttleTreshold ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.009f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.2f, (float)0.025f);
            Vec3 moveDir = Vec3.m_82498_((float)this.f_24974_.m_146909_(), (float)this.f_24974_.m_146908_());
            double xDir = (double)this.speed * moveDir.m_7096_() * 0.02;
            double yDir = (double)this.speed * moveDir.m_7098_() * 0.02;
            double zDir = (double)this.speed * moveDir.m_7094_() * 0.02;
            Vec3 delta = this.f_24974_.m_20184_();
            this.f_24974_.m_20256_(delta.m_82520_(xDir, yDir, zDir));
        }
    }
}

