/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.entities;

import io.github.flemmli97.improvedmobs.ai.WaterNavigation;
import io.github.flemmli97.improvedmobs.entities.RiddenSummonEntity;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class AquaticSummonEntity
extends RiddenSummonEntity {
    public static final ResourceLocation SUMMONED_AQUATIC_ID = new ResourceLocation("improvedmobs", "aquatic_entity");
    private static final EntityDataAccessor<Boolean> DATA_ID_MOVING = SynchedEntityData.m_135353_(AquaticSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Vec3 leapDir;
    private int leapTick;

    public AquaticSummonEntity(Level level) {
        super((EntityType<? extends Mob>)EntityType.f_20455_, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new AquaticMoveControl(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_MOVING, (Object)false);
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_MOVING);
    }

    protected void setMoving(boolean moving) {
        this.f_19804_.m_135381_(DATA_ID_MOVING, (Object)moving);
    }

    public boolean m_6040_() {
        return true;
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterNavigation(this, level);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        --this.leapTick;
        if (this.leapTick < 0 || this.m_20096_()) {
            this.leapDir = null;
        }
        if (this.m_20072_()) {
            this.m_20301_(300);
        }
    }

    public int m_8132_() {
        return 180;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.1f, travelVector);
            this.m_20256_(this.m_20184_().m_82490_(0.85));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!this.isMoving() && this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            if (this.leapDir != null) {
                this.m_6478_(MoverType.SELF, this.leapDir);
            }
            super.m_7023_(travelVector);
        }
    }

    @Override
    public ResourceLocation serverSideID() {
        return SUMMONED_AQUATIC_ID;
    }

    public boolean m_6146_() {
        return true;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12005_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12002_;
    }

    public float m_6100_() {
        return super.m_6100_() * 0.8f;
    }

    public void setLeapDir(Vec3 dir) {
        this.leapDir = dir;
        this.leapTick = 20;
    }

    protected static class AquaticMoveControl
    extends MoveControl {
        private final AquaticSummonEntity mount;

        public AquaticMoveControl(AquaticSummonEntity mob) {
            super((Mob)mob);
            this.mount = mob;
        }

        public void m_8126_() {
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.mount.m_21573_().m_26571_()) {
                this.mount.m_7910_(0.0f);
                this.mount.setMoving(false);
                return;
            }
            Vec3 dir = new Vec3(this.f_24975_ - this.mount.m_20185_(), this.f_24976_ - this.mount.m_20186_(), this.f_24977_ - this.mount.m_20189_());
            double len = dir.m_82553_();
            double e = dir.f_82479_ / len;
            double f = dir.f_82480_ / len;
            double g = dir.f_82481_ / len;
            float h = (float)(Mth.m_14136_((double)dir.f_82481_, (double)dir.f_82479_) * 57.2957763671875) - 90.0f;
            this.mount.m_146922_(this.m_24991_(this.mount.m_146908_(), h, 90.0f));
            this.mount.f_20883_ = this.mount.m_146908_();
            float i = (float)(this.f_24978_ * this.mount.m_21133_(Attributes.f_22279_));
            float j = Mth.m_14179_((float)0.125f, (float)this.mount.m_6113_(), (float)i);
            this.mount.m_7910_(j);
            double k = Math.sin((double)(this.mount.f_19797_ + this.mount.m_142049_()) * 0.5) * 0.05;
            double l = Math.cos(this.mount.m_146908_() * ((float)Math.PI / 180));
            double m = Math.sin(this.mount.m_146908_() * ((float)Math.PI / 180));
            double n = Math.sin((double)(this.mount.f_19797_ + this.mount.m_142049_()) * 0.75) * 0.05;
            this.mount.m_20256_(this.mount.m_20184_().m_82520_(k * l * 0.8, n * (m + l) * 0.15 + (double)j * f * 0.1, k * m * 0.8));
            LookControl lookControl = this.mount.m_21563_();
            double o = this.mount.m_20185_() + e * 2.0;
            double p = this.mount.m_20188_() + f / len;
            double q = this.mount.m_20189_() + g * 2.0;
            double r = lookControl.m_24969_();
            double s = lookControl.m_24970_();
            double t = lookControl.m_24971_();
            if (!lookControl.m_186069_()) {
                r = o;
                s = p;
                t = q;
            }
            this.mount.m_21563_().m_24950_(Mth.m_14139_((double)0.125, (double)r, (double)o), Mth.m_14139_((double)0.125, (double)s, (double)p), Mth.m_14139_((double)0.125, (double)t, (double)q), 10.0f, 40.0f);
            this.mount.setMoving(true);
        }
    }
}

