/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.config;

import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.tenshilib.api.config.IConfigListValue;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class BreakableBlocks
implements IConfigListValue<BreakableBlocks> {
    private final Set<String> blocks = new HashSet<String>();
    private List<String> configString = new ArrayList<String>();
    private boolean initialized;

    public boolean canBreak(BlockState state, BlockPos pos, BlockGetter level, @Nullable Entity entity, CollisionContext ctx) {
        Mob mob;
        if (!this.initialized) {
            this.initialize();
        }
        if (!Config.CommonConfig.idleBreak && entity instanceof Mob && (mob = (Mob)entity).m_5448_() == null) {
            return false;
        }
        if (state.m_60742_(level, pos, ctx).m_83281_()) {
            return false;
        }
        if (!Config.CommonConfig.breakTileEntities && state.m_155947_()) {
            return false;
        }
        ResourceLocation id = PlatformUtils.INSTANCE.blocks().getIDFrom((Object)state.m_60734_());
        if (Config.CommonConfig.breakingAsBlacklist) {
            return !this.blocks.contains(id.toString()) && !this.blocks.contains(id.m_135827_());
        }
        return this.blocks.contains(id.m_135827_()) || this.blocks.contains(id.toString());
    }

    public BreakableBlocks readFromString(List<String> arr) {
        this.blocks.clear();
        this.configString = arr;
        this.initialized = false;
        return this;
    }

    public void initialize() {
        this.initialized = true;
        this.blocks.clear();
        HashSet<String> blackList = new HashSet<String>();
        for (String s : this.configString) {
            if (s.startsWith("!")) {
                BreakableBlocks.addBlocks(s.substring(1), blackList);
                continue;
            }
            BreakableBlocks.addBlocks(s, this.blocks);
        }
        this.blocks.removeAll(blackList);
    }

    private static void addBlocks(String s, Set<String> blocks) {
        if (s.startsWith("#")) {
            Iterable tag = Registry.f_122824_.m_206058_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(s.substring(1))));
            tag.forEach(h -> blocks.add(Registry.f_122824_.m_7981_((Object)((Block)h.m_203334_())).toString()));
        } else {
            blocks.add(s);
        }
    }

    public List<String> writeToString() {
        return this.configString;
    }

    public static String use() {
        return "Usage: id|namespace|#tag. Put \"!\" infront to exclude blocks. E.g. \"minecraft\", \"minecraft:dirt\" or \"#minecraft:planks\"";
    }
}

