/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.ai.util;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;

public interface ItemAI {
    public void attack(Mob var1, LivingEntity var2, InteractionHand var3);

    public int cooldown();

    public ItemType type();

    public UsableHand prefHand();

    default public boolean useHand() {
        return false;
    }

    default public int maxUseCount(Mob entity, InteractionHand hand) {
        return 20;
    }

    default public void onReset(Mob entity, InteractionHand hand) {
    }

    default public boolean applies(ItemStack stack) {
        return true;
    }

    default public boolean isIncompatibleWith(LivingEntity entity, ItemStack stack) {
        return false;
    }

    public static enum UsableHand {
        MAIN,
        OFF,
        BOTH;

    }

    public static enum ItemType {
        NONSTRAFINGITEM,
        STRAFINGITEM,
        STANDING;

    }
}

