/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.secondchanceforge;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.infernalstudios.secondchanceforge.SecondChanceSoundEvents;
import org.infernalstudios.secondchanceforge.config.SecondChanceConfig;

@Mod.EventBusSubscriber(modid="secondchanceforge", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SecondChanceEvents {
    @SubscribeEvent
    public void onEntityDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entity instanceof Player) {
            double remainderHealth;
            Player player = (Player)entity;
            double activationHealth = (Boolean)SecondChanceConfig.CONFIG.usePercentConfig.get() != false ? (Double)SecondChanceConfig.CONFIG.secondChanceActivationPercent.get() * (double)player.m_21233_() / 100.0 : (Double)SecondChanceConfig.CONFIG.secondChanceActivationHealth.get();
            double d = remainderHealth = (Boolean)SecondChanceConfig.CONFIG.usePercentConfig.get() != false ? (Double)SecondChanceConfig.CONFIG.secondChanceRemainderPercent.get() * (double)player.m_21233_() / 100.0 : (Double)SecondChanceConfig.CONFIG.secondChanceHealthRemainder.get();
            if (((Boolean)SecondChanceConfig.CONFIG.secondChanceEnabled.get()).booleanValue() && this.canActivateSecondChance(source) && player.m_21223_() <= event.getAmount() && (double)player.m_21223_() >= activationHealth) {
                if (((Boolean)SecondChanceConfig.CONFIG.secondChanceSound.get()).booleanValue()) {
                    player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SecondChanceSoundEvents.CLASSIC_HURT.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
                }
                event.setAmount((float)((double)player.m_21223_() - remainderHealth));
            }
        }
    }

    private boolean canActivateSecondChance(DamageSource source) {
        boolean activateForExplosion = (Boolean)SecondChanceConfig.CONFIG.secondChanceExplosions.get() != false && source.m_19372_();
        boolean activateForMob = (Boolean)SecondChanceConfig.CONFIG.secondChanceMobs.get() != false && source.m_19385_().equals("mob");
        boolean activateForFallDamage = (Boolean)SecondChanceConfig.CONFIG.secondChanceFalls.get() != false && source.m_19385_().equals("fall");
        boolean activateForAnvil = (Boolean)SecondChanceConfig.CONFIG.secondChanceAnvils.get() != false && source.m_19385_().equals("anvil");
        boolean activateForLightning = (Boolean)SecondChanceConfig.CONFIG.secondChanceLightning.get() != false && source.m_19385_().equals("lightningBolt");
        boolean activateForElytraCrash = (Boolean)SecondChanceConfig.CONFIG.secondChanceElytraCrash.get() != false && source.m_19385_().equals("flyIntoWall");
        boolean activateForFallingBlocks = (Boolean)SecondChanceConfig.CONFIG.secondChanceFallingBlocks.get() != false && source.m_19385_().equals("fallingBlock");
        boolean activateForMagic = (Boolean)SecondChanceConfig.CONFIG.secondChanceMagic.get() != false && source.m_19387_();
        boolean activateForPlayer = (Boolean)SecondChanceConfig.CONFIG.secondChancePlayers.get() != false && source.m_19385_().equals("player");
        boolean activateForTrident = (Boolean)SecondChanceConfig.CONFIG.secondChanceTridents.get() != false && source.m_19385_().equals("trident");
        boolean activateForArrow = (Boolean)SecondChanceConfig.CONFIG.secondChanceArrows.get() != false && source.m_19385_().equals("arrow");
        boolean activateForFirework = (Boolean)SecondChanceConfig.CONFIG.secondChanceFireworks.get() != false && source.m_19385_().equals("fireworks");
        boolean activateForWitherSkull = (Boolean)SecondChanceConfig.CONFIG.secondChanceWitherSkulls.get() != false && source.m_19385_().equals("witherSkull");
        boolean activateForStalactite = (Boolean)SecondChanceConfig.CONFIG.secondChanceStalactite.get() != false && source.m_19385_().equals("fallingStalactite");
        boolean activateForStalagmite = (Boolean)SecondChanceConfig.CONFIG.secondChanceStalagmite.get() != false && source.m_19385_().equals("stalagmite");
        return activateForExplosion || activateForMob || activateForFallDamage || activateForAnvil || activateForLightning || activateForElytraCrash || activateForFallingBlocks || activateForMagic || activateForPlayer || activateForTrident || activateForArrow || activateForFirework || activateForWitherSkull || activateForStalactite || activateForStalagmite;
    }
}

