/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mvs.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class YLevelUpOne
extends StructureFeature<JigsawConfiguration> {
    public static final Codec<JigsawConfiguration> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(JigsawConfiguration::m_204802_), (App)Codec.intRange((int)0, (int)10).fieldOf("size").forGetter(JigsawConfiguration::m_67765_)).apply((Applicative)codec, JigsawConfiguration::new));

    public YLevelUpOne() {
        super(CODEC, YLevelUpOne::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static boolean isOnWater(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkpos = context.f_197355_();
        BlockPos centerOfChunk = chunkpos.m_151394_(0);
        int landHeight = context.f_197352_().m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_197357_());
        BlockState topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_123342_() + landHeight);
        return !topBlock.m_60819_().m_76178_();
    }

    public static boolean isAllowedTerrainHeightChange(PieceGeneratorSupplier.Context<JigsawConfiguration> context, Pair<Integer, Integer> size) {
        ChunkPos pos = context.f_197355_();
        int allowedTerrainHeightRange = 2;
        int[] cornerHeights = context.m_197375_(pos.m_151390_(), ((Integer)size.getFirst()).intValue(), pos.m_151393_(), ((Integer)size.getSecond()).intValue());
        int minHeight = Math.min(Math.min(cornerHeights[0], cornerHeights[1]), Math.min(cornerHeights[2], cornerHeights[3]));
        int maxHeight = Math.max(Math.max(cornerHeights[0], cornerHeights[1]), Math.max(cornerHeights[2], cornerHeights[3]));
        return Math.abs(maxHeight - minHeight) <= allowedTerrainHeightRange;
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkpos = context.f_197355_();
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209820_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209825_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209826_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209821_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209835_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 5)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209822_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209823_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209830_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209831_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209824_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209827_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        if (context.f_197352_().m_212265_(BuiltinStructureSets.f_209832_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10)) {
            return true;
        }
        return context.f_197352_().m_212265_(BuiltinStructureSets.f_209834_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 2);
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!YLevelUpOne.isFeatureChunk(context)) {
            return Optional.empty();
        }
        if (!YLevelUpOne.isAllowedTerrainHeightChange(context, (Pair<Integer, Integer>)Pair.of((Object)3, (Object)3))) {
            return Optional.empty();
        }
        if (YLevelUpOne.isOnWater(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        blockpos = blockpos.m_6630_(5);
        Optional structurePiecesGenerator = JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)true);
        return structurePiecesGenerator;
    }
}

