/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.resourcepacks;

import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import org.apache.commons.lang3.tuple.Pair;
import org.embeddedt.modernfix.FileWalker;
import org.embeddedt.modernfix.core.config.ModernFixEarlyConfig;
import org.embeddedt.modernfix.util.FileUtil;
import org.embeddedt.modernfix.util.PackTypeHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VanillaPackResources.class})
public class VanillaPackMixin {
    @Shadow
    @Final
    private static Map<PackType, Path> f_182296_;
    private static LoadingCache<Pair<Path, Integer>, List<Path>> pathStreamLoadingCache;
    private static Set<String> containedPaths;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void cacheContainedPaths(PackMetadataSection arg, String[] p_i47912_1_, CallbackInfo ci) {
        if (containedPaths != null) {
            return;
        }
        containedPaths = new ObjectOpenHashSet();
        Joiner slashJoiner = Joiner.on((char)'/');
        for (PackType type : PackType.values()) {
            if (!PackTypeHelper.isVanillaPackType(type)) continue;
            Path root = f_182296_.get(type);
            if (root == null) {
                throw new IllegalStateException("No filesystem for vanilla " + type.name() + " assets");
            }
            try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
                stream.map(path -> root.relativize(path.toAbsolutePath())).forEach(path -> containedPaths.add(slashJoiner.join((Object)type.m_10305_(), path, new Object[0])));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ((ObjectOpenHashSet)containedPaths).trim();
    }

    @Redirect(method={"getResources(Ljava/util/Collection;ILjava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;Ljava/util/function/Predicate;)V"}, at=@At(value="INVOKE", target="Ljava/nio/file/Files;walk(Ljava/nio/file/Path;I[Ljava/nio/file/FileVisitOption;)Ljava/util/stream/Stream;"))
    private static Stream<Path> useCacheForLoading(Path path, int maxDepth, FileVisitOption[] fileVisitOptions) throws IOException {
        try {
            return ((List)pathStreamLoadingCache.get((Object)Pair.of((Object)path, (Object)maxDepth))).stream();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    @Inject(method={"hasResource"}, at={@At(value="INVOKE", target="Ljava/lang/Class;getResource(Ljava/lang/String;)Ljava/net/URL;")}, cancellable=true)
    private void useCacheForExistence(PackType type, ResourceLocation location, CallbackInfoReturnable<Boolean> cir) {
        if (!PackTypeHelper.isVanillaPackType(type)) {
            return;
        }
        cir.setReturnValue((Object)containedPaths.contains(type.m_10305_() + "/" + location.m_135827_() + "/" + FileUtil.normalize(location.m_135815_())));
    }

    @Inject(method={"getResourceAsStream(Lnet/minecraft/server/packs/PackType;Lnet/minecraft/resources/ResourceLocation;)Ljava/io/InputStream;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getResourceAsStreamFast(PackType type, ResourceLocation location, CallbackInfoReturnable<InputStream> cir) {
        if (!ModernFixEarlyConfig.OPTIFINE_PRESENT) {
            Path rootPath = f_182296_.get(type);
            Path targetPath = rootPath.resolve(location.m_135827_() + "/" + location.m_135815_());
            try {
                cir.setReturnValue((Object)Files.newInputStream(targetPath, new OpenOption[0]));
            }
            catch (IOException e) {
                cir.setReturnValue(null);
            }
        }
    }

    static {
        pathStreamLoadingCache = CacheBuilder.newBuilder().build((CacheLoader)FileWalker.INSTANCE);
        containedPaths = null;
    }
}

