/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.simplemobs.network;

import java.util.function.Supplier;
import net.mcreator.simplemobs.SimpleMobsMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimpleMobsModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SimpleMobsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "simple_mobs_mapvars";
        public boolean Aggro = false;
        public boolean knight_attack_1 = false;
        public boolean knight_attack_2 = false;
        public boolean samurai_attack_1 = false;
        public boolean samurai_attack_2 = false;
        public boolean Aggro_sam = false;
        public double dist_eye = 1.6;
        public boolean sam_atk_prep = false;
        public double loop = 0.0;
        public double loop_part = 8.0;
        public double samurai_head_rotation_x = 0.0;
        public double samurai_head_rotation_z = 0.0;
        public double samurai_head_rotation_y = 0.0;
        public double samradius = 1.0;
        public boolean samurai_attack_3 = false;
        public double sam_old_x = 0.0;
        public double sam_old_y = 0.0;
        public double sam_old_z = 0.0;
        public boolean sam_atk3_pt1 = false;
        public boolean sam_atk3_pt2 = false;
        public boolean samurai_attack_4 = false;
        public boolean sam_atk_4_pt2 = false;
        public boolean knight_attack_3 = false;
        public boolean knight_atk_3_pt1 = false;
        public boolean knight_atk_3_pt2 = false;
        public double i = 1.0;
        public double j = 1.0;
        public boolean collide = false;
        public double x = 1.0;
        public double circle_direction = 0.0;
        public double r = 0.0;
        public boolean r_decrease = false;
        public boolean ball_damage = false;
        public boolean ball_explosion = false;
        public boolean knight_attack_4 = false;
        public boolean knight_attack_4_done = false;
        public double loop2 = 0.0;
        public boolean aggronin = false;
        public double arrow_direction = 0.0;
        public boolean GiantAggro = false;
        public boolean aggrocave = false;
        public boolean damageblock = false;
        public boolean aggrosand = false;
        public boolean aggroogre = false;
        public boolean aggro_tails = false;
        public boolean flame = false;
        public boolean palace_spawn = false;
        public double ghost_x = 0.0;
        public double ghost_y = 0.0;
        public double ghost_z = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.Aggro = nbt.m_128471_("Aggro");
            this.knight_attack_1 = nbt.m_128471_("knight_attack_1");
            this.knight_attack_2 = nbt.m_128471_("knight_attack_2");
            this.samurai_attack_1 = nbt.m_128471_("samurai_attack_1");
            this.samurai_attack_2 = nbt.m_128471_("samurai_attack_2");
            this.Aggro_sam = nbt.m_128471_("Aggro_sam");
            this.dist_eye = nbt.m_128459_("dist_eye");
            this.sam_atk_prep = nbt.m_128471_("sam_atk_prep");
            this.loop = nbt.m_128459_("loop");
            this.loop_part = nbt.m_128459_("loop_part");
            this.samurai_head_rotation_x = nbt.m_128459_("samurai_head_rotation_x");
            this.samurai_head_rotation_z = nbt.m_128459_("samurai_head_rotation_z");
            this.samurai_head_rotation_y = nbt.m_128459_("samurai_head_rotation_y");
            this.samradius = nbt.m_128459_("samradius");
            this.samurai_attack_3 = nbt.m_128471_("samurai_attack_3");
            this.sam_old_x = nbt.m_128459_("sam_old_x");
            this.sam_old_y = nbt.m_128459_("sam_old_y");
            this.sam_old_z = nbt.m_128459_("sam_old_z");
            this.sam_atk3_pt1 = nbt.m_128471_("sam_atk3_pt1");
            this.sam_atk3_pt2 = nbt.m_128471_("sam_atk3_pt2");
            this.samurai_attack_4 = nbt.m_128471_("samurai_attack_4");
            this.sam_atk_4_pt2 = nbt.m_128471_("sam_atk_4_pt2");
            this.knight_attack_3 = nbt.m_128471_("knight_attack_3");
            this.knight_atk_3_pt1 = nbt.m_128471_("knight_atk_3_pt1");
            this.knight_atk_3_pt2 = nbt.m_128471_("knight_atk_3_pt2");
            this.i = nbt.m_128459_("i");
            this.j = nbt.m_128459_("j");
            this.collide = nbt.m_128471_("collide");
            this.x = nbt.m_128459_("x");
            this.circle_direction = nbt.m_128459_("circle_direction");
            this.r = nbt.m_128459_("r");
            this.r_decrease = nbt.m_128471_("r_decrease");
            this.ball_damage = nbt.m_128471_("ball_damage");
            this.ball_explosion = nbt.m_128471_("ball_explosion");
            this.knight_attack_4 = nbt.m_128471_("knight_attack_4");
            this.knight_attack_4_done = nbt.m_128471_("knight_attack_4_done");
            this.loop2 = nbt.m_128459_("loop2");
            this.aggronin = nbt.m_128471_("aggronin");
            this.arrow_direction = nbt.m_128459_("arrow_direction");
            this.GiantAggro = nbt.m_128471_("GiantAggro");
            this.aggrocave = nbt.m_128471_("aggrocave");
            this.damageblock = nbt.m_128471_("damageblock");
            this.aggrosand = nbt.m_128471_("aggrosand");
            this.aggroogre = nbt.m_128471_("aggroogre");
            this.aggro_tails = nbt.m_128471_("aggro_tails");
            this.flame = nbt.m_128471_("flame");
            this.palace_spawn = nbt.m_128471_("palace_spawn");
            this.ghost_x = nbt.m_128459_("ghost_x");
            this.ghost_y = nbt.m_128459_("ghost_y");
            this.ghost_z = nbt.m_128459_("ghost_z");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("Aggro", this.Aggro);
            nbt.m_128379_("knight_attack_1", this.knight_attack_1);
            nbt.m_128379_("knight_attack_2", this.knight_attack_2);
            nbt.m_128379_("samurai_attack_1", this.samurai_attack_1);
            nbt.m_128379_("samurai_attack_2", this.samurai_attack_2);
            nbt.m_128379_("Aggro_sam", this.Aggro_sam);
            nbt.m_128347_("dist_eye", this.dist_eye);
            nbt.m_128379_("sam_atk_prep", this.sam_atk_prep);
            nbt.m_128347_("loop", this.loop);
            nbt.m_128347_("loop_part", this.loop_part);
            nbt.m_128347_("samurai_head_rotation_x", this.samurai_head_rotation_x);
            nbt.m_128347_("samurai_head_rotation_z", this.samurai_head_rotation_z);
            nbt.m_128347_("samurai_head_rotation_y", this.samurai_head_rotation_y);
            nbt.m_128347_("samradius", this.samradius);
            nbt.m_128379_("samurai_attack_3", this.samurai_attack_3);
            nbt.m_128347_("sam_old_x", this.sam_old_x);
            nbt.m_128347_("sam_old_y", this.sam_old_y);
            nbt.m_128347_("sam_old_z", this.sam_old_z);
            nbt.m_128379_("sam_atk3_pt1", this.sam_atk3_pt1);
            nbt.m_128379_("sam_atk3_pt2", this.sam_atk3_pt2);
            nbt.m_128379_("samurai_attack_4", this.samurai_attack_4);
            nbt.m_128379_("sam_atk_4_pt2", this.sam_atk_4_pt2);
            nbt.m_128379_("knight_attack_3", this.knight_attack_3);
            nbt.m_128379_("knight_atk_3_pt1", this.knight_atk_3_pt1);
            nbt.m_128379_("knight_atk_3_pt2", this.knight_atk_3_pt2);
            nbt.m_128347_("i", this.i);
            nbt.m_128347_("j", this.j);
            nbt.m_128379_("collide", this.collide);
            nbt.m_128347_("x", this.x);
            nbt.m_128347_("circle_direction", this.circle_direction);
            nbt.m_128347_("r", this.r);
            nbt.m_128379_("r_decrease", this.r_decrease);
            nbt.m_128379_("ball_damage", this.ball_damage);
            nbt.m_128379_("ball_explosion", this.ball_explosion);
            nbt.m_128379_("knight_attack_4", this.knight_attack_4);
            nbt.m_128379_("knight_attack_4_done", this.knight_attack_4_done);
            nbt.m_128347_("loop2", this.loop2);
            nbt.m_128379_("aggronin", this.aggronin);
            nbt.m_128347_("arrow_direction", this.arrow_direction);
            nbt.m_128379_("GiantAggro", this.GiantAggro);
            nbt.m_128379_("aggrocave", this.aggrocave);
            nbt.m_128379_("damageblock", this.damageblock);
            nbt.m_128379_("aggrosand", this.aggrosand);
            nbt.m_128379_("aggroogre", this.aggroogre);
            nbt.m_128379_("aggro_tails", this.aggro_tails);
            nbt.m_128379_("flame", this.flame);
            nbt.m_128379_("palace_spawn", this.palace_spawn);
            nbt.m_128347_("ghost_x", this.ghost_x);
            nbt.m_128347_("ghost_y", this.ghost_y);
            nbt.m_128347_("ghost_z", this.ghost_z);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                SimpleMobsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_142572_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "simple_mobs_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                SimpleMobsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getPlayer().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getPlayer().f_19853_);
                if (mapdata != null) {
                    SimpleMobsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    SimpleMobsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getPlayer().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getPlayer().f_19853_)) != null) {
                SimpleMobsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

