/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.simplemobs.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.mcreator.simplemobs.entity.NineTailsEntity;
import net.mcreator.simplemobs.init.SimpleMobsModEntities;
import net.mcreator.simplemobs.procedures.NoaiProcedure;
import net.mcreator.simplemobs.procedures.PromossgolemProcedure;
import net.mcreator.simplemobs.procedures.ProwerehurtProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MossGolemEntity
extends Monster
implements IAnimatable {
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET = SynchedEntityData.m_135353_(MossGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final HurtByTargetGoal hurtByTargetGoal = new HurtByTargetGoal((PathfinderMob)this, new Class[0]);
    private int attackTimer;
    public int clientSideAttackTime;
    private LivingEntity clientSideCachedAttackTarget;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public int getAttackDuration() {
        return 75;
    }

    public MossGolemEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<MossGolemEntity>)((EntityType)SimpleMobsModEntities.MOSS_GOLEM.get()), world);
    }

    public MossGolemEntity(EntityType<MossGolemEntity> type, Level world) {
        super(type, world);
        this.f_19793_ = 2.0f;
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_ATTACK_TARGET, (Object)0);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean m_8036_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8036_() && NoaiProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8045_() && NoaiProcedure.execute((Entity)entity);
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, false){

            public boolean m_8036_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8036_() && NoaiProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8045_() && NoaiProcedure.execute((Entity)entity);
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8036_() && NoaiProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8045_() && NoaiProcedure.execute((Entity)entity);
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new MossGolemAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new NineTailsEntity.FollowTargetGoal((Mob)this, 1.0, 10.0f){

            @Override
            public boolean m_8036_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8036_() && NoaiProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8045_() && NoaiProcedure.execute((Entity)entity);
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8036_() && NoaiProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8045_() && NoaiProcedure.execute((Entity)entity);
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8036_() && NoaiProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                MossGolemEntity entity = MossGolemEntity.this;
                Level world = MossGolemEntity.this.f_19853_;
                return super.m_8045_() && NoaiProcedure.execute((Entity)entity);
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.deepslate_bricks.place"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.17);
        builder = builder.m_22268_(Attributes.f_22276_, 1000.0);
        builder = builder.m_22268_(Attributes.f_22284_, 50.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    public float getAttackDamage() {
        float f = (float)this.m_21133_(Attributes.f_22281_);
        if (this.f_19853_.m_46791_() == Difficulty.HARD) {
            f *= 1.5f;
        }
        return f;
    }

    public void m_8107_() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            this.f_21345_.m_25352_(5, (Goal)this.hurtByTargetGoal);
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        this.destroyLeavesBlocks();
        this.doLaserParticleEffects();
        super.m_8107_();
    }

    public void m_6075_() {
        super.m_6075_();
        PromossgolemProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        ProwerehurtProcedure.execute((LevelAccessor)this.f_19853_, (Entity)this);
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source == DamageSource.f_19315_) {
            return false;
        }
        if (source == DamageSource.f_19314_) {
            return false;
        }
        if (source == DamageSource.f_19312_) {
            return false;
        }
        if (source == DamageSource.f_19306_) {
            return false;
        }
        if (source == DamageSource.f_19320_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    private void destroyLeavesBlocks() {
        if (this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
            boolean flag = false;
            AABB aabb = this.m_142469_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!(block instanceof LeavesBlock)) continue;
                flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    private void doLaserParticleEffects() {
        if (this.m_6084_()) {
            if (this.f_19853_.f_46443_ && this.hasActiveAttackTarget()) {
                LivingEntity livingentity;
                if (this.clientSideAttackTime < this.getAttackDuration()) {
                    ++this.clientSideAttackTime;
                }
                if ((livingentity = this.getActiveAttackTarget()) != null) {
                    this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                    this.m_21563_().m_8128_();
                    double d5 = this.getAttackAnimationScale(0.0f);
                    double d0 = livingentity.m_20185_() - this.m_20185_();
                    double d1 = livingentity.m_20227_(0.5) - this.m_20188_();
                    double d2 = livingentity.m_20189_() - this.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.f_19796_.nextDouble();
                    while (d4 < d3) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + d0 * (d4 += 1.8 - d5 + this.f_19796_.nextDouble() * (1.7 - d5)), this.m_20188_() + d1 * d4, this.m_20189_() + d2 * d4, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.hasActiveAttackTarget()) {
                this.m_146922_(this.f_20885_);
            }
        }
    }

    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity entity = this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.clientSideCachedAttackTarget = (LivingEntity)entity;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.m_5448_();
    }

    void setActiveAttackTarget(int p_32818_) {
        this.f_19804_.m_135381_(DATA_ID_ATTACK_TARGET, (Object)p_32818_);
    }

    public boolean hasActiveAttackTarget() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET) != 0;
    }

    public float getAttackAnimationScale(float scale) {
        return ((float)this.clientSideAttackTime + scale) / (float)this.getAttackDuration();
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (DATA_ID_ATTACK_TARGET.equals(accessor)) {
            this.clientSideAttackTime = 0;
            this.clientSideCachedAttackTarget = null;
        }
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == this.getMaxDeathCount()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (this.f_19853_.m_5776_()) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)this.f_19796_.nextFloat(), this.m_20186_() + (double)this.f_19796_.nextFloat(), this.m_20189_() + (double)this.f_19796_.nextFloat(), 2.0, 2.0, 2.0);
            }
        }
    }

    int getMaxDeathCount() {
        return 50;
    }

    private PlayState predicate(AnimationEvent animationEvent) {
        if (!this.m_6084_()) {
            animationEvent.getController().transitionLengthTicks = 0.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.death"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42407_) {
            animationEvent.getController().transitionLengthTicks = 20.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.attack1a"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42417_) {
            animationEvent.getController().transitionLengthTicks = 15.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.attack1b"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42413_) {
            animationEvent.getController().transitionLengthTicks = 10.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.attack2"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42414_) {
            animationEvent.getController().transitionLengthTicks = 4.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.attack2a"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42416_) {
            animationEvent.getController().transitionLengthTicks = 10.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.attack3"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42749_) {
            animationEvent.getController().transitionLengthTicks = 2.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.attack3b"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42303_) {
            animationEvent.getController().transitionLengthTicks = 0.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.sleep"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_41937_) {
            animationEvent.getController().transitionLengthTicks = 0.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.wake"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_41982_) {
            animationEvent.getController().transitionLengthTicks = 0.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.stun1"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42674_) {
            animationEvent.getController().transitionLengthTicks = 1.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.stun2"));
        } else if (this.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_41940_) {
            animationEvent.getController().transitionLengthTicks = 0.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.trans"));
        } else if (animationEvent.isMoving()) {
            animationEvent.getController().transitionLengthTicks = 5.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.walk"));
        } else {
            animationEvent.getController().transitionLengthTicks = 5.0;
            animationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brute.idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public class MossGolemAttackGoal
    extends Goal {
        private final MossGolemEntity golem;
        private int laserAttackTick;
        private int laserCooldown = 0;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private Path path;
        private boolean canPenalize = false;

        public boolean m_8036_() {
            LivingEntity livingentity = this.golem.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.golem.getPersistentData().m_128471_("Far") || this.golem.getPersistentData().m_128471_("noai") || this.golem.getPersistentData().m_128471_("nolaser")) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.golem.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.golem.m_21187_().nextInt(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.golem.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.golem.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.golem.m_5448_();
            --this.laserCooldown;
            if (livingentity != null) {
                boolean flag = this.golem.m_142582_((Entity)livingentity);
                this.golem.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                if (!flag) {
                    this.golem.m_6710_(null);
                } else {
                    this.laserTick(livingentity);
                }
            }
        }

        public void m_8056_() {
            this.laserAttackTick = -10;
            LivingEntity livingentity = this.golem.m_5448_();
            if (livingentity != null) {
                this.golem.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
            }
            this.golem.m_21573_().m_26536_(this.path, this.speedModifier);
            this.golem.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.golem.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.golem.getPersistentData().m_128471_("Far") || this.golem.getPersistentData().m_128471_("noai") || this.golem.getPersistentData().m_128471_("nolaser")) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.golem.m_21573_().m_26571_();
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8041_() {
            this.golem.setActiveAttackTarget(0);
            this.golem.m_6710_(null);
            this.golem.m_21561_(false);
            this.golem.m_21573_().m_26573_();
        }

        public MossGolemAttackGoal(MossGolemEntity entity, double speed, boolean memory) {
            this.golem = entity;
            this.speedModifier = speed;
            this.followingTargetEvenIfNotSeen = memory;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        protected void laserTick(LivingEntity livingentity) {
            if (this.laserCooldown <= 0) {
                ++this.laserAttackTick;
            }
            if (this.laserAttackTick == 0) {
                this.golem.setActiveAttackTarget(livingentity.m_142049_());
                if (!this.golem.m_20067_()) {
                    this.golem.m_5496_(this.getLaserChargeSound(), 2.0f, 1.0f);
                }
            } else if (this.laserAttackTick >= this.golem.getAttackDuration()) {
                float f = 2.0f;
                Vec3 vec3 = this.golem.m_20154_().m_82542_(1.0, 1.0, 1.0).m_82541_().m_82490_(3.0);
                if (this.golem.f_19853_.m_46791_() == Difficulty.HARD) {
                    f *= 2.0f;
                }
                this.golem.m_5496_(this.getLaserFireSound(), 1.0f, 0.7f);
                livingentity.m_5496_(this.getLaserFireSound(), 1.0f, 0.7f);
                livingentity.m_6469_(DamageSource.m_19367_((Entity)this.golem, (Entity)this.golem), f);
                livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this.golem), 25.0f);
                this.golem.m_6710_(null);
                this.laserCooldown = 20;
            }
        }

        protected double getAttackReachSqr(LivingEntity entity) {
            return this.golem.m_20205_() * 1.5f * this.golem.m_20205_() * 1.5f + entity.m_20205_();
        }

        protected SoundEvent getLaserChargeSound() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("simple_mobs:laser_charge"));
        }

        protected SoundEvent getLaserFireSound() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("simple_mobs:electricity_zap"));
        }
    }
}

