/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.simplemobs.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LeafParticle
extends TextureSheetParticle {
    protected static final float TAU = (float)Math.PI * 2;
    protected static final int FADE_DURATION = 16;
    protected static final double WATER_FRICTION = 0.05;
    protected final float windCoefficient;
    protected final float maxRotateSpeed;
    protected final int maxRotateTime;
    private final SpriteSet spriteSet;
    protected int rotateTime = 0;
    private Quaternion quaternion = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private Random random = new Random();

    protected LeafParticle(ClientLevel clientWorld, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, double r, double g, double b, SpriteSet spriteSet) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0);
        this.spriteSet = spriteSet;
        float initialTilt = this.random.nextFloat() * 360.0f;
        float baseR = 1.0f;
        float baseG = 1.0f;
        float baseB = 1.0f;
        float variance = 0.01f;
        Quaternion initialTiltQuaternion = Vector3f.f_122223_.m_122240_(initialTilt);
        this.quaternion.m_80148_(initialTiltQuaternion);
        this.f_107226_ = 0.08f + this.random.nextFloat() * 0.04f;
        this.windCoefficient = 0.6f + this.random.nextFloat() * 0.4f;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.f_107219_ = true;
        this.f_107225_ = Math.max(1, 100 + (this.random.nextInt(200) - 100));
        this.f_107227_ = baseR + (this.random.nextFloat() * 2.0f - 1.0f) * variance;
        this.f_107228_ = baseG + (this.random.nextFloat() * 2.0f - 1.0f) * variance;
        this.f_107229_ = baseB + (this.random.nextFloat() * 2.0f - 1.0f) * variance;
        this.maxRotateTime = (3 + this.random.nextInt(5)) * 20;
        this.maxRotateSpeed = (float)(this.random.nextBoolean() ? -1 : 1) * (0.1f + 2.4f * this.random.nextFloat()) * ((float)Math.PI * 2) / 20.0f;
        this.f_107231_ = this.f_107204_ = this.random.nextFloat() * ((float)Math.PI * 2);
        this.f_107663_ *= 1.0f;
        this.m_108335_(spriteSet);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
        ++this.f_107224_;
        if (this.f_107224_ >= this.f_107225_ + 1 - 16) {
            this.f_107230_ -= 0.0625f;
        }
        if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        if (this.f_107208_.m_6425_(new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_)).m_205070_(FluidTags.f_13131_)) {
            this.f_107216_ = 0.0;
            this.rotateTime = 0;
            this.f_107215_ *= 0.95;
            this.f_107217_ *= 0.95;
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            if (this.f_107218_) {
                if (this.rotateTime == 0) {
                    this.f_107231_ = this.random.nextFloat() * ((float)Math.PI * 2);
                }
                this.rotateTime = this.maxRotateTime;
            } else {
                this.rotateTime = Math.min(this.rotateTime + 1, this.maxRotateTime);
                this.f_107231_ += (float)this.rotateTime / (float)this.maxRotateTime * this.maxRotateSpeed;
            }
            this.f_107215_ += (0.2 - this.f_107215_) * (double)this.windCoefficient / 60.0;
            this.f_107217_ += (0.1 - this.f_107217_) * (double)this.windCoefficient / 60.0;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
    }

    public static LeafParticleProvider provider(SpriteSet spriteSet) {
        return new LeafParticleProvider(spriteSet);
    }

    public void m_5744_(VertexConsumer p_107678_, Camera p_107679_, float p_107680_) {
        float tiltSpeed = 0.01f;
        float dynamicTiltY = (float)this.f_107224_ / (float)this.f_107225_ * 360.0f * tiltSpeed;
        if (dynamicTiltY != 0.0f && !this.f_107218_) {
            Quaternion tiltYQuaternion = Vector3f.f_122225_.m_122240_(dynamicTiltY);
            this.quaternion.m_80148_(tiltYQuaternion);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(p_107680_);
        Vec3 renderVec3 = p_107679_.m_90583_();
        float renderX = (float)(Mth.m_14139_((double)p_107680_, (double)this.f_107209_, (double)this.f_107212_) - renderVec3.m_7096_());
        float renderY = (float)(Mth.m_14139_((double)p_107680_, (double)this.f_107210_, (double)this.f_107213_) - renderVec3.m_7098_());
        float renderZ = (float)(Mth.m_14139_((double)p_107680_, (double)this.f_107211_, (double)this.f_107214_) - renderVec3.m_7094_());
        Vector3f renderVector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        renderVector3f1.m_122251_(this.quaternion);
        Vector3f[] renderAvector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float renderF4 = this.m_5902_(p_107680_);
        for (Vector3f renderVector3f : renderAvector3f) {
            renderVector3f.m_122251_(this.quaternion);
            renderVector3f.m_122261_(renderF4);
            renderVector3f.m_122272_(renderX, renderY, renderZ);
        }
        float renderMinX = Math.min(Math.min(renderAvector3f[0].m_122239_(), renderAvector3f[1].m_122239_()), Math.min(renderAvector3f[2].m_122239_(), renderAvector3f[3].m_122239_()));
        float renderMaxX = Math.max(Math.max(renderAvector3f[0].m_122239_(), renderAvector3f[1].m_122239_()), Math.max(renderAvector3f[2].m_122239_(), renderAvector3f[3].m_122239_()));
        float renderMinY = Math.min(Math.min(renderAvector3f[0].m_122260_(), renderAvector3f[1].m_122260_()), Math.min(renderAvector3f[2].m_122260_(), renderAvector3f[3].m_122260_()));
        float renderMaxY = Math.max(Math.max(renderAvector3f[0].m_122260_(), renderAvector3f[1].m_122260_()), Math.max(renderAvector3f[2].m_122260_(), renderAvector3f[3].m_122260_()));
        if (renderMinX < renderMaxX && renderMinY < renderMaxY) {
            p_107678_.m_5483_((double)renderAvector3f[0].m_122239_(), (double)renderAvector3f[0].m_122260_(), (double)renderAvector3f[0].m_122269_()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            p_107678_.m_5483_((double)renderAvector3f[1].m_122239_(), (double)renderAvector3f[1].m_122260_(), (double)renderAvector3f[1].m_122269_()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            p_107678_.m_5483_((double)renderAvector3f[2].m_122239_(), (double)renderAvector3f[2].m_122260_(), (double)renderAvector3f[2].m_122269_()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            p_107678_.m_5483_((double)renderAvector3f[3].m_122239_(), (double)renderAvector3f[3].m_122260_(), (double)renderAvector3f[3].m_122269_()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public static class LeafParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public LeafParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new LeafParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, 1.0, 1.0, 1.0, this.spriteSet);
        }
    }
}

