/*
 * Decompiled with CFR 0.152.
 */
package com.nethersdelight.core.registry;

import com.nethersdelight.common.block.BlackstoneStoveBlock;
import com.nethersdelight.common.block.FungusColonyBlock;
import com.nethersdelight.common.block.HoglinMountBlock;
import com.nethersdelight.common.block.MimicarnationBlock;
import com.nethersdelight.common.block.PropelplantBerryCaneBlock;
import com.nethersdelight.common.block.PropelplantBerryStemBlock;
import com.nethersdelight.common.block.PropelplantCaneBlock;
import com.nethersdelight.common.block.PropelplantStemBlock;
import com.nethersdelight.common.block.RichSoulSoilBlock;
import com.nethersdelight.common.block.SoulCompostBlock;
import com.nethersdelight.common.block.StuffedHoglinBlock;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class NDBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"nethersdelight");
    public static final RegistryObject<Block> BLACKSTONE_STOVE = BLOCKS.register("blackstone_stove", () -> new BlackstoneStoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50735_).m_60953_(NDBlocks.litBlockEmission(13, 9))));
    public static final RegistryObject<Block> CRIMSON_FUNGUS_COLONY = BLOCKS.register("crimson_fungus_colony", () -> new FungusColonyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50700_), (Supplier<Item>)Items.f_41954_.delegate));
    public static final RegistryObject<Block> WARPED_FUNGUS_COLONY = BLOCKS.register("warped_fungus_colony", () -> new FungusColonyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50691_), (Supplier<Item>)Items.f_41955_.delegate));
    public static final RegistryObject<Block> STUFFED_HOGLIN = BLOCKS.register("stuffed_hoglin", () -> new StuffedHoglinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_).m_60955_()));
    public static final RegistryObject<Block> HOGLIN_MOUNT = BLOCKS.register("hoglin_mount", () -> new HoglinMountBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50106_).m_60955_().m_60953_(light -> 1)));
    public static final RegistryObject<Block> RICH_SOUL_SOIL = BLOCKS.register("rich_soul_soil", () -> new RichSoulSoilBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50136_)));
    public static final RegistryObject<Block> SOUL_COMPOST = BLOCKS.register("soul_compost", () -> new SoulCompostBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50136_)));
    public static final RegistryObject<Block> MIMICARNATION = BLOCKS.register("mimicarnation", () -> new MimicarnationBlock(MobEffects.f_19609_, 8, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_60953_(light -> 8)));
    public static final RegistryObject<Block> POTTED_MIMICARNATION = BLOCKS.register("potted_mimicarnation", () -> new FlowerPotBlock((Block)MIMICARNATION.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60955_().m_60953_(light -> 8)));
    public static final RegistryObject<Block> PROPELPLANT_STEM = BLOCKS.register("propelplant_stem", () -> new PropelplantStemBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50700_).m_60918_(SoundType.f_56740_).m_60978_(0.1f)));
    public static final RegistryObject<Block> PROPELPLANT_BERRY_STEM = BLOCKS.register("propelplant_berry_stem", () -> new PropelplantBerryStemBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PROPELPLANT_STEM.get())).m_60953_(NDBlocks.propelplantBlockEmission(9))));
    public static final RegistryObject<Block> PROPELPLANT_CANE = BLOCKS.register("propelplant_cane", () -> new PropelplantCaneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PROPELPLANT_STEM.get()))));
    public static final RegistryObject<Block> PROPELPLANT_BERRY_CANE = BLOCKS.register("propelplant_berry_cane", () -> new PropelplantBerryCaneBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PROPELPLANT_STEM.get())).m_60953_(NDBlocks.propelplantBlockEmission(9))));
    public static final RegistryObject<Block> PROPELPLANT_TORCH = BLOCKS.register("propelplant_torch", () -> new TorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PROPELPLANT_STEM.get())).m_60953_(light -> 12), (ParticleOptions)ParticleTypes.f_123744_));
    public static final RegistryObject<Block> PROPELPLANT_WALL_TORCH = BLOCKS.register("propelplant_wall_torch", () -> new WallTorchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)PROPELPLANT_STEM.get())).m_60916_((Block)PROPELPLANT_TORCH.get()).m_60953_(light -> 12), (ParticleOptions)ParticleTypes.f_123744_));

    private static ToIntFunction<BlockState> litBlockEmission(int light, int soul) {
        return state -> {
            if (((Boolean)state.m_61143_((Property)BlackstoneStoveBlock.SOUL)).booleanValue()) {
                return soul;
            }
            if (!((Boolean)state.m_61143_((Property)BlackstoneStoveBlock.SOUL)).booleanValue() && ((Boolean)state.m_61143_((Property)BlackstoneStoveBlock.LIT)).booleanValue()) {
                return light;
            }
            return 0;
        };
    }

    private static ToIntFunction<BlockState> propelplantBlockEmission(int pearl) {
        return state -> {
            if (((Boolean)state.m_61143_((Property)PropelplantBerryStemBlock.PEARL)).booleanValue()) {
                return pearl;
            }
            return 0;
        };
    }
}

