/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.lightengine;

import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import ca.spottedleaf.starlight.common.light.StarLightLightingProvider;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.LightEventListener;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelLightEngine.class})
public abstract class LevelLightEngineMixin
implements LightEventListener,
StarLightLightingProvider {
    @Shadow
    @Nullable
    private LayerLightEngine<?, ?> f_75802_;
    @Shadow
    @Nullable
    private LayerLightEngine<?, ?> f_75803_;
    @Unique
    protected StarLightInterface lightEngine;
    @Unique
    protected final Long2ObjectOpenHashMap<SWMRNibbleArray[]> blockLightMap = new Long2ObjectOpenHashMap();
    @Unique
    protected final Long2ObjectOpenHashMap<SWMRNibbleArray[]> skyLightMap = new Long2ObjectOpenHashMap();

    @Override
    public final StarLightInterface getLightEngine() {
        return this.lightEngine;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void construct(LightChunkGetter chunkProvider, boolean hasBlockLight, boolean hasSkyLight, CallbackInfo ci) {
        this.lightEngine = chunkProvider.m_7653_() instanceof Level ? new StarLightInterface(chunkProvider, hasSkyLight, hasBlockLight, (LevelLightEngine)this) : new StarLightInterface(null, hasSkyLight, hasBlockLight, (LevelLightEngine)this);
        this.f_75802_ = null;
        this.f_75803_ = null;
    }

    @Overwrite
    public void m_142202_(BlockPos pos) {
        this.lightEngine.blockChange(pos.m_7949_());
    }

    @Overwrite
    public void m_142519_(BlockPos pos, int level) {
    }

    @Overwrite
    public boolean m_142182_() {
        return this.lightEngine.hasUpdates();
    }

    @Overwrite
    public int m_142528_(int maxUpdateCount, boolean doSkylight, boolean skipEdgeLightPropagation) {
        boolean hadUpdates = this.m_142182_();
        this.lightEngine.propagateChanges();
        return hadUpdates ? 1 : 0;
    }

    @Overwrite
    public void m_6191_(SectionPos pos, boolean notReady) {
        this.lightEngine.sectionChange(pos, notReady);
    }

    @Overwrite
    public void m_141940_(ChunkPos pos, boolean lightEnabled) {
    }

    @Overwrite
    public LayerLightEventListener m_75814_(LightLayer lightType) {
        return lightType == LightLayer.BLOCK ? this.lightEngine.getBlockReader() : this.lightEngine.getSkyReader();
    }

    @Overwrite
    public void m_5687_(LightLayer lightType, SectionPos pos, @Nullable DataLayer nibble, boolean trustEdges) {
    }

    @Overwrite
    public void m_6462_(ChunkPos pos, boolean retainData) {
    }

    @Overwrite
    public int m_75831_(BlockPos pos, int ambientDarkness) {
        return this.lightEngine.getRawBrightness(pos, ambientDarkness);
    }

    @Override
    public void clientUpdateLight(LightLayer lightType, SectionPos pos, DataLayer nibble, boolean trustEdges) {
        if (this.getClass() != LevelLightEngine.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        ChunkAccess chunk = this.getLightEngine().getAnyChunkNow(pos.m_123341_(), pos.m_123343_());
        switch (lightType) {
            case BLOCK: {
                SWMRNibbleArray[] blockNibbles = (SWMRNibbleArray[])this.blockLightMap.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> StarLightEngine.getFilledEmptyLight((LevelHeightAccessor)this.lightEngine.getWorld()));
                blockNibbles[pos.m_123342_() - WorldUtil.getMinLightSection((LevelHeightAccessor)this.lightEngine.getWorld())] = SWMRNibbleArray.fromVanilla(nibble);
                if (chunk == null) break;
                ((ExtendedChunk)chunk).setBlockNibbles(blockNibbles);
                this.lightEngine.getLightAccess().m_6506_(LightLayer.BLOCK, pos);
                break;
            }
            case SKY: {
                SWMRNibbleArray[] skyNibbles = (SWMRNibbleArray[])this.skyLightMap.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> StarLightEngine.getFilledEmptyLight((LevelHeightAccessor)this.lightEngine.getWorld()));
                skyNibbles[pos.m_123342_() - WorldUtil.getMinLightSection((LevelHeightAccessor)this.lightEngine.getWorld())] = SWMRNibbleArray.fromVanilla(nibble);
                if (chunk == null) break;
                ((ExtendedChunk)chunk).setSkyNibbles(skyNibbles);
                this.lightEngine.getLightAccess().m_6506_(LightLayer.SKY, pos);
                break;
            }
        }
    }

    @Override
    public void clientRemoveLightData(ChunkPos chunkPos) {
        if (this.getClass() != LevelLightEngine.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        this.blockLightMap.remove(CoordinateUtils.getChunkKey(chunkPos));
        this.skyLightMap.remove(CoordinateUtils.getChunkKey(chunkPos));
    }

    @Override
    public void clientChunkLoad(ChunkPos pos, LevelChunk chunk) {
        if (this.getClass() != LevelLightEngine.class) {
            throw new IllegalStateException("This hook is for the CLIENT ONLY");
        }
        long key = CoordinateUtils.getChunkKey(pos);
        SWMRNibbleArray[] blockNibbles = (SWMRNibbleArray[])this.blockLightMap.get(key);
        SWMRNibbleArray[] skyNibbles = (SWMRNibbleArray[])this.skyLightMap.get(key);
        if (blockNibbles != null) {
            ((ExtendedChunk)chunk).setBlockNibbles(blockNibbles);
        }
        if (skyNibbles != null) {
            ((ExtendedChunk)chunk).setSkyNibbles(skyNibbles);
        }
    }
}

