/*
 * Decompiled with CFR 0.152.
 */
package com.sindarin.farsightedmobs;

import com.sindarin.farsightedmobs.Config;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="farsightedmobs")
public class FarsightedMobs {
    public static final String MOD_ID = "farsightedmobs";
    public static final Logger LOGGER = LogManager.getLogger((String)"farsightedmobs");

    public FarsightedMobs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register(Config.class);
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinWorldEvent event) {
        EntityType type;
        Monster mob;
        double originalFollow;
        if (event.getWorld().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity instanceof Monster && (originalFollow = (mob = (Monster)livingEntity).m_21172_(Attributes.f_22277_)) < (Double)Config.SERVER.defaultHostileRange.get()) {
            FarsightedMobs.ChangeBaseAttributeValue((LivingEntity)mob, Attributes.f_22277_, (Double)Config.SERVER.defaultHostileRange.get());
        }
        if (Config.SERVER.mobAttributeMap.containsKey(type = livingEntity.m_6095_())) {
            List<Pair<Attribute, Double>> values = Config.SERVER.mobAttributeMap.get(type);
            for (Pair<Attribute, Double> change : values) {
                FarsightedMobs.ChangeBaseAttributeValue(livingEntity, (Attribute)change.getLeft(), (Double)change.getRight());
            }
        }
        FarsightedMobs.FixFollowRange(livingEntity);
    }

    private static void ChangeBaseAttributeValue(LivingEntity entity, Attribute attribute, double value) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance == null) {
            LOGGER.warn("No attribute instance found for " + attribute.getRegistryName());
            return;
        }
        attributeInstance.m_22100_(value);
    }

    private static void FixFollowRange(LivingEntity livingEntity) {
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.f_21346_.m_148105_().forEach(wrappedGoal -> {
                Goal goal = wrappedGoal.m_26015_();
                if (goal instanceof NearestAttackableTargetGoal) {
                    NearestAttackableTargetGoal natGoal = (NearestAttackableTargetGoal)goal;
                    natGoal.f_26051_ = natGoal.f_26051_.m_26883_(livingEntity.m_21133_(Attributes.f_22277_));
                }
            });
        }
    }
}

