/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world.gen.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import untamedwilds.block.IPostGenUpdate;
import untamedwilds.config.ConfigFeatureControl;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;

public class FeatureVegetation
extends Feature<ProbabilityFeatureConfiguration> {
    public FeatureVegetation(Codec<ProbabilityFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext context) {
        Random rand = context.m_159774_().m_5822_();
        WorldGenLevel world = context.m_159774_();
        BlockPos genPos = world.m_5452_(Heightmap.Types.OCEAN_FLOOR, context.m_159777_());
        if (((List)ConfigFeatureControl.dimensionFeatureBlacklist.get()).contains(world.m_6018_().m_46472_().m_135782_().toString())) {
            return false;
        }
        boolean flag = false;
        int x = rand.nextInt(16) - 8;
        int z = rand.nextInt(16) - 8;
        BlockPos pos = genPos.m_142082_(x, 0, z);
        Pair<Block, Integer> flora = FloraTypes.getFloraForPos(world, genPos);
        if (flora != null) {
            Block block = (Block)flora.getFirst();
            int size = (Integer)flora.getSecond();
            for (int i = 0; i < size; ++i) {
                BlockPos blockpos = pos.m_142082_(rand.nextInt(6) - rand.nextInt(6), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(6) - rand.nextInt(6));
                if (!world.m_8055_(blockpos.m_7495_()).m_204336_(ModTags.ModBlockTags.ALOE_PLANTABLE_ON) || world.m_8055_(blockpos).m_60783_((BlockGetter)world, blockpos, Direction.UP) || !world.m_6425_(blockpos).m_76178_() || block == null) continue;
                if (world.m_8055_(blockpos).m_60734_() == Blocks.f_50125_ && world.m_8055_(blockpos.m_7495_()).m_60734_() == Blocks.f_50440_) {
                    world.m_7731_(blockpos.m_7495_(), (BlockState)Blocks.f_50440_.m_49966_().m_61124_((Property)GrassBlock.f_56637_, (Comparable)Boolean.valueOf(false)), 2);
                }
                world.m_7731_(blockpos, block.m_49966_(), 2);
                if (block instanceof IPostGenUpdate) {
                    ((IPostGenUpdate)block).updatePostGen((LevelAccessor)world, blockpos);
                }
                flag = true;
            }
        }
        return flag;
    }

    public static enum FloraTypes {
        TEMPERATE_BUSH((Block)ModBlock.BUSH_TEMPERATE.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 24, Biome.BiomeCategory.FOREST, Biome.BiomeCategory.SWAMP, Biome.BiomeCategory.EXTREME_HILLS, Biome.BiomeCategory.TAIGA, Biome.BiomeCategory.PLAINS),
        CREOSOTE_BUSH((Block)ModBlock.BUSH_CREOSOTE.get(), 2, (Boolean)ConfigFeatureControl.addFlora.get(), false, 4, Biome.BiomeCategory.MESA, Biome.BiomeCategory.DESERT),
        ELEPHANT_EAR((Block)ModBlock.ELEPHANT_EAR.get(), 8, (Boolean)ConfigFeatureControl.addFlora.get(), false, 24, Biome.BiomeCategory.JUNGLE),
        HEMLOCK((Block)ModBlock.HEMLOCK.get(), 1, (Boolean)ConfigFeatureControl.addFlora.get(), false, 12, Biome.BiomeCategory.FOREST),
        TITAN_ARUM((Block)ModBlock.TITAN_ARUM.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 1, Biome.BiomeCategory.JUNGLE),
        ZIMBABWE_ALOE((Block)ModBlock.ZIMBABWE_ALOE.get(), 4, (Boolean)ConfigFeatureControl.addFlora.get(), false, 1, Biome.BiomeCategory.MESA),
        FLOWER_YARROW((Block)ModBlock.YARROW.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 18, Biome.BiomeCategory.FOREST, Biome.BiomeCategory.PLAINS, Biome.BiomeCategory.MOUNTAIN),
        GRASS_JUNEGRASS((Block)ModBlock.JUNEGRASS.get(), 8, (Boolean)ConfigFeatureControl.addFlora.get(), false, 18, Biome.BiomeCategory.PLAINS),
        CANOLA((Block)ModBlock.CANOLA.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 12, Biome.BiomeCategory.PLAINS),
        CYCAD((Block)ModBlock.CYCAD.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 12, Biome.BiomeCategory.JUNGLE);

        public Block type;
        public int rarity;
        public boolean enabled;
        public boolean spawnsInWater;
        public int size;
        public Biome.BiomeCategory[] spawnBiomes;

        private FloraTypes(Block type, int rolls, boolean add, boolean spawnsInWater, int size, Biome.BiomeCategory ... biomes) {
            this.type = type;
            this.rarity = rolls;
            this.enabled = add;
            this.spawnsInWater = spawnsInWater;
            this.spawnBiomes = biomes;
            this.size = size;
        }

        public static Pair<Block, Integer> getFloraForPos(WorldGenLevel world, BlockPos pos) {
            Biome biome = (Biome)world.m_204166_(pos).m_203334_();
            ArrayList<FloraTypes> types = new ArrayList<FloraTypes>();
            for (FloraTypes type : FloraTypes.values()) {
                if (!type.enabled || !type.spawnsInWater && world.m_8055_(pos).m_60734_() == Blocks.f_49990_) continue;
                for (Biome.BiomeCategory biomeTypes : type.spawnBiomes) {
                    if (biome.f_47442_ != biomeTypes) continue;
                    for (int i = 0; i < type.rarity; ++i) {
                        types.add(type);
                    }
                }
            }
            if (!types.isEmpty()) {
                int i = new Random().nextInt(types.size());
                return new Pair((Object)((FloraTypes)((Object)types.get((int)i))).type, (Object)((FloraTypes)((Object)types.get((int)i))).size);
            }
            return null;
        }
    }
}

