/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import untamedwilds.UntamedWilds;
import untamedwilds.entity.ComplexMob;
import untamedwilds.init.ModEntity;
import untamedwilds.network.SyncTextureData;
import untamedwilds.network.UntamedInstance;
import untamedwilds.util.EntityDataHolder;
import untamedwilds.util.EntityDataHolderClient;
import untamedwilds.util.EntityUtils;
import untamedwilds.util.JSONLoader;
import untamedwilds.util.SpeciesDataHolder;

@Mod.EventBusSubscriber(modid="untamedwilds")
public class EntityDataListenerEvent {
    private static boolean isLoaded = false;
    public static final JSONLoader<EntityDataHolder> ENTITY_DATA_HOLDERS = new JSONLoader<EntityDataHolder>("entities", EntityDataHolder.CODEC);
    public static EntityDataHolder TARANTULA;
    public static EntityDataHolder KING_CRAB;
    public static EntityDataHolder BUTTERFLY;
    public static EntityDataHolder GIANT_CLAM;
    public static EntityDataHolder GIANT_SALAMANDER;
    public static EntityDataHolder NEWT;
    public static EntityDataHolder AROWANA;
    public static EntityDataHolder FOOTBALL_FISH;
    public static EntityDataHolder SHARK;
    public static EntityDataHolder SUNFISH;
    public static EntityDataHolder WHALE_SHARK;
    public static EntityDataHolder TREVALLY;
    public static EntityDataHolder TRIGGERFISH;
    public static EntityDataHolder CATFISH;
    public static EntityDataHolder SPADEFISH;
    public static EntityDataHolder SNAKE;
    public static EntityDataHolder ANACONDA;
    public static EntityDataHolder SOFTSHELL_TURTLE;
    public static EntityDataHolder TORTOISE;
    public static EntityDataHolder MONITOR;
    public static EntityDataHolder AARDVARK;
    public static EntityDataHolder HIPPO;
    public static EntityDataHolder RHINO;
    public static EntityDataHolder HYENA;
    public static EntityDataHolder BOAR;
    public static EntityDataHolder BEAR;
    public static EntityDataHolder BIG_CAT;
    public static EntityDataHolder BISON;
    public static EntityDataHolder CAMEL;
    public static EntityDataHolder MANATEE;
    public static EntityDataHolder BALEEN_WHALE;
    public static EntityDataHolder OPOSSUM;
    public static EntityDataHolder WILDEBEEST;
    public static EntityDataHolder SAWFISH;
    public static EntityDataHolder TERROR_BIRD;
    public static EntityDataHolder SPITTER;

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ENTITY_DATA_HOLDERS);
        EntityDataListenerEvent.registerData();
    }

    public static void registerData() {
        TARANTULA = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.TARANTULA.get());
        KING_CRAB = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.KING_CRAB.get());
        BUTTERFLY = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.BUTTERFLY.get());
        GIANT_CLAM = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.GIANT_CLAM.get());
        GIANT_SALAMANDER = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.GIANT_SALAMANDER.get());
        NEWT = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.NEWT.get());
        AROWANA = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.AROWANA.get());
        FOOTBALL_FISH = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.FOOTBALL_FISH.get());
        SHARK = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SHARK.get());
        SUNFISH = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SUNFISH.get());
        TREVALLY = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.TREVALLY.get());
        WHALE_SHARK = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.WHALE_SHARK.get());
        TRIGGERFISH = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.TRIGGERFISH.get());
        CATFISH = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.CATFISH.get());
        SPADEFISH = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SPADEFISH.get());
        SAWFISH = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SAWFISH.get());
        SNAKE = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SNAKE.get());
        ANACONDA = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.ANACONDA.get());
        SOFTSHELL_TURTLE = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SOFTSHELL_TURTLE.get());
        TORTOISE = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.TORTOISE.get());
        MONITOR = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.MONITOR.get());
        BEAR = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.BEAR.get());
        BIG_CAT = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.BIG_CAT.get());
        AARDVARK = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.AARDVARK.get());
        BOAR = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.BOAR.get());
        RHINO = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.RHINO.get());
        HYENA = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.HYENA.get());
        HIPPO = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.HIPPO.get());
        BISON = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.BISON.get());
        CAMEL = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.CAMEL.get());
        MANATEE = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.MANATEE.get());
        BALEEN_WHALE = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.BALEEN_WHALE.get());
        OPOSSUM = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.OPOSSUM.get());
        WILDEBEEST = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.WILDEBEEST.get());
        TERROR_BIRD = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.TERROR_BIRD.get());
        SPITTER = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SPITTER.get());
        isLoaded = true;
    }

    public static boolean isEntityDataLoaded() {
        return isLoaded;
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        UntamedWilds.LOGGER.info("Firing player login event");
        EntityDataListenerEvent.registerData();
        for (EntityType<?> types : ComplexMob.ENTITY_DATA_HASH.keySet()) {
            ResourceLocation entityName = types.getRegistryName();
            int size = 0;
            for (SpeciesDataHolder speciesData : ComplexMob.ENTITY_DATA_HASH.get(types).getSpeciesData()) {
                UntamedInstance.sendToClient(new SyncTextureData(entityName, speciesData.getName(), speciesData.getSkins(), size++), (ServerPlayer)event.getPlayer());
            }
        }
    }

    public static EntityDataHolder registerEntityData(EntityType<?> typeIn) {
        String nameIn = Objects.requireNonNull(typeIn.getRegistryName()).m_135815_();
        if (ENTITY_DATA_HOLDERS.getData(new ResourceLocation("untamedwilds", nameIn)) != null) {
            EntityDataHolder data = ENTITY_DATA_HOLDERS.getData(new ResourceLocation("untamedwilds", nameIn));
            EntityDataListenerEvent.processData(data, typeIn);
            return data;
        }
        return null;
    }

    private static void processData(EntityDataHolder dataIn, EntityType<?> typeIn) {
        ComplexMob.ENTITY_DATA_HASH.put(typeIn, dataIn);
        EntityDataListenerEvent.processSkins(dataIn, typeIn.getRegistryName().m_135815_());
        for (SpeciesDataHolder speciesData : ComplexMob.ENTITY_DATA_HASH.get(typeIn).getSpeciesData()) {
            if (!ComplexMob.CLIENT_DATA_HASH.containsKey(typeIn)) {
                ComplexMob.CLIENT_DATA_HASH.put(typeIn, new EntityDataHolderClient(new HashMap<Integer, Map<String, SoundEvent>>(), new HashMap<Integer, String>()));
            }
            ComplexMob.CLIENT_DATA_HASH.get(typeIn).species_data.put(speciesData.getVariant(), speciesData.getName());
        }
    }

    private static void processSkins(EntityDataHolder dataIn, String nameIn) {
        for (SpeciesDataHolder speciesDatum : dataIn.getSpeciesData()) {
            EntityUtils.buildSkinArrays(nameIn, speciesDatum.getName().toLowerCase(), dataIn, speciesDatum.getVariant(), ComplexMob.TEXTURES_COMMON, ComplexMob.TEXTURES_RARE);
        }
    }
}

