/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeSpawnEggItem;
import untamedwilds.entity.ComplexMob;
import untamedwilds.util.EntityUtils;

public class UntamedSpawnEggItem
extends ForgeSpawnEggItem {
    private int currentSpecies = 0;
    private boolean isCached;
    private final Supplier<? extends EntityType<? extends Mob>> entityType;

    public UntamedSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> typeIn, int primaryColorIn, int secondaryColorIn, Item.Properties builder) {
        super(typeIn, primaryColorIn, secondaryColorIn, builder);
        this.entityType = typeIn;
        this.isCached = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.untamedwilds.spawn_egg_info").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TranslatableComponent("item.untamedwilds.spawn_egg_current", new Object[]{this.getCurrentSpeciesName(stack)}).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    private String getCurrentSpeciesName(ItemStack stack) {
        int i;
        if (!this.isCached && stack.m_41782_() && stack.m_41783_().m_128441_("EntityTag")) {
            this.currentSpecies = stack.m_41783_().m_128469_("EntityTag").m_128451_("Variant");
            this.isCached = true;
        }
        return (i = this.currentSpecies - 1) >= 0 ? EntityUtils.getVariantName(this.entityType.get(), i) + " (" + i + ")" : "Random";
    }

    public void increaseSpeciesNumber(int intIn) {
        this.currentSpecies = intIn % (ComplexMob.getEntityData(this.entityType.get()).getSpeciesData().size() + 1);
        this.isCached = true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!(worldIn instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        if (playerIn.m_20161_()) {
            this.increaseSpeciesNumber(this.currentSpecies + 1);
            playerIn.m_5661_((Component)new TranslatableComponent("item.untamedwilds.spawn_egg_change", new Object[]{this.getCurrentSpeciesName(itemstack)}), true);
            itemstack.m_41751_(new CompoundTag());
            if (this.currentSpecies != 0) {
                CompoundTag entityNBT = new CompoundTag();
                entityNBT.m_128405_("Variant", this.currentSpecies - 1);
                itemstack.m_41783_().m_128365_("EntityTag", (Tag)entityNBT);
            }
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockHitResult raytraceresult = UntamedSpawnEggItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.m_82425_();
        if (!(worldIn.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (worldIn.m_7966_(playerIn, blockpos) && playerIn.m_36204_(blockpos, raytraceresult.m_82434_(), itemstack)) {
            Integer species = this.currentSpecies - 1 < 0 ? null : Integer.valueOf(this.currentSpecies - 1);
            EntityUtils.createMobFromItem((ServerLevel)worldIn, itemstack, this.entityType.get(), species, blockpos, playerIn, false, true);
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            worldIn.m_151552_(GameEvent.f_157810_, (Entity)playerIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public InteractionResult m_6225_(UseOnContext useContext) {
        Entity spawn;
        BlockEntity tileentity;
        Level world = useContext.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = useContext.m_43722_();
        BlockPos blockpos = useContext.m_8083_();
        Direction direction = useContext.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50085_) && (tileentity = world.m_7702_(blockpos)) instanceof SpawnerBlockEntity) {
            BaseSpawner abstractspawner = ((SpawnerBlockEntity)tileentity).m_59801_();
            EntityType entitytype1 = this.m_43228_(itemstack.m_41783_());
            abstractspawner.m_45462_(entitytype1);
            CompoundTag entityNBT_2 = new CompoundTag();
            entityNBT_2.m_128359_("id", entitytype1.getRegistryName().toString());
            if (this.currentSpecies - 1 >= 0) {
                entityNBT_2.m_128405_("Variant", this.currentSpecies - 1);
                entityNBT_2.m_128350_("Size", ComplexMob.getEntityData(entitytype1).getScale(this.currentSpecies - 1));
            } else {
                entityNBT_2.m_128350_("Size", 1.0f);
            }
            abstractspawner.m_142667_(world, blockpos, new SpawnData(entityNBT_2, Optional.empty()));
            tileentity.m_6596_();
            world.m_7260_(blockpos, blockstate, blockstate, 3);
            itemstack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_142300_(direction);
        if (!itemstack.m_41782_()) {
            itemstack.m_41751_(new CompoundTag());
        }
        if ((spawn = this.entityType.get().m_20655_((ServerLevel)world, itemstack.m_41783_(), null, useContext.m_43723_(), blockpos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP)) == null) {
            return InteractionResult.PASS;
        }
        Integer species = this.currentSpecies - 1 < 0 ? null : Integer.valueOf(this.currentSpecies - 1);
        EntityUtils.createMobFromItem((ServerLevel)world, itemstack, this.entityType.get(), species, blockpos1, useContext.m_43723_(), false, true);
        if (useContext.m_43723_() != null) {
            itemstack.m_41774_(1);
            world.m_142346_((Entity)useContext.m_43723_(), GameEvent.f_157810_, blockpos);
        }
        return InteractionResult.CONSUME;
    }
}

